#ifndef	__MAILBOX_H__
#define	__MAILBOX_H__

#include <time.h>
#include <stdio.h>

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__STREAM_H__
#include <sys_stream.h>
#endif

#ifndef	__FILES_H__
#include <sys_files.h>
#endif

#ifndef	__MMDF__

#ifndef	__MAIL_MARKER
#ifndef	__FROM_MARKER
#define	__MMDF__
#endif
#endif

#endif

#ifdef	__MMDF__
#define	__MAIL_MARKER	"\01\01\01\01\n"
#endif

#ifndef	MAILDIR
#define	MAILDIR	"/usr/spool/mail"
#endif

typedef	struct
{
	char	mb_userid[33];
	STREAM	*mb_stream;
	int		mb_from;
	int		mb_header;
	int		mb_from_marker;
	char	mb_lbuf[256];
	int		mb_rewrite;
}	MAILBOX;

typedef	struct
{
	long	m_base;
	long	m_body;			/*	size of header	*/
	char	*m_from;
	char	*m_name;
	char	*m_addr;
	char	*m_tov[32];
	int		m_toc;
	char	*m_subject;
	char	*m_userid;
	time_t	m_sent;
	time_t	m_recv;
	char	m_buf[2048];
}	MAIL;

#define	ulock_mailbox(lck)		ulock_file(lck)
#define	from_mailbox(mbox)		(mbox->mb_from ? mbox->mb_lbuf : NULL)

IMPORT	LOCK	*lock_mailbox PROTO((char *userid));
IMPORT	char	*name_mailbox PROTO((char *userid));
IMPORT	MAILBOX	*open_mailbox PROTO((char *userid, char *mode));
IMPORT	MAILBOX	*rewrite_mailbox PROTO((MAILBOX *mbox));
IMPORT	void	close_mailbox PROTO((MAILBOX *mbox));
IMPORT	long	skip_mailbox PROTO((MAILBOX *mbox, long pos));	/* skip letter */
IMPORT	void	rewind_mailbox PROTO((MAILBOX *mbox));
IMPORT	MAIL	*scan_mailbox PROTO((MAILBOX *mailbox));
IMPORT	int		gets_mailbox PROTO((MAILBOX *mailbox, char *addr, int len));
IMPORT	int		read_mailbox PROTO((MAILBOX *mailbox, PTR addr, int max));	/* read letter */	
IMPORT	long	seek_mailbox PROTO((MAILBOX *mailbox, long pos));	/* seeks from line */
IMPORT	long	tell_mailbox PROTO((MAILBOX *mailbox));
IMPORT	long	next_mailbox PROTO((MAILBOX *mailbox));				/* finds a 'from ' entry */
IMPORT	void	clear_mailbox PROTO((char *userid));
IMPORT	int		mailgrp PROTO((void));
#endif
