/*  Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

	Declairation for VU door program interfaces for use with
	MS-DOS bulletin board systems.
*/

#ifndef PASCAL
#define PASCAL  pascal
#endif                                            


/*      Console I/O service traps */

extern  int     PASCAL  (*cio_pending)(void);
extern  int     PASCAL  (*cio_read)(void);
extern  void    PASCAL  (*cio_write)(unsigned char code);
extern  void    PASCAL  (*cio_idle)(void);
extern  void    PASCAL  (*cio_startup)(void);
extern  void    PASCAL  (*cio_shutdown)(void);
extern  void    PASCAL  (*cio_ansipos)(char *ansistr);
extern  void    PASCAL  (*cio_ansiattr)(char *ansistr);
extern  void    PASCAL  (*cio_cursor)(int row, int col);
extern  void    PASCAL  (*cio_setattr)(ATTR attr);

typedef unsigned char   BYTE;

typedef enum
{
	NODOOR_TYPE,
	PCBOARD_TYPE,
	WWIV_TYPE,
	DOORSYS_TYPE
}   DOOR_TYPE;

/*      PC Board interface */

typedef struct
{
	char    pcb_display[2];
	char    pcb_printer[2];
	char    pcb_page[2];
	char    pcb_alarm[2];
	char    pcb_sysop;
	char    pcb_connection[2];
	char    pcb_color;
	char    pcb_chat_status;
	char    pcb_dce_speed[5];
	char    pcb_usr_speed[5];
	short   pcb_uid;
	char    pcb_fname[15];
	char    pcb_passwd[12];
	short   pcb_time_login;
	short   pcb_time_used;
	char    pcb_stime_login[5];
	short   pcb_time_quota;
	short   pcb_dload_quota;
	char    pcb_conference;
	BYTE    pcb_joined[5];
	BYTE    pcb_scanned[5];
	short   pcb_add_time;
	short   pcb_credit_time;
	char    pcb_language[4];
	char    pcb_name[25];
	short   pcb_time_left;
	char    pcb_node;
	char    pcb_event_time[5];
	char    pcb_event_active[2];
	char    pcb_event_slide[2];
	long    pcb_msg_num;
	char    pcb_port;
	short   pcb_area;               /* has 14.5 extended area flag */
}   PCBOARD;

/*      For PC Board 14.5 or later, we have an extended
	pcboard.sys area for new attributes.  If 14.5 or later, the
	new 16 bit pcb_area_select flag is copied into the pcb_area
	flag.  Otherwise, the pcb_area flag will have the old
	pcb_conference flag.  A portion of the new bitmap will also
	be moved into the bitmap field of the lower 128 byte struct.

	This movement of conf. select info is done because we only
	hold the initial 128 byte portion of the pcboard.sys file in
	memory at any time.
*/

typedef struct
{
	char    pcb_ansi;
	char    pcb_last_event_date[8];
	short   pcb_last_event_time;
	char    pcb_dos_exit;
	char    pcb_event_pending;
	char    pcb_stop_uploads;
	short   pcb_area_select;
	BYTE    pcb_joined[];
}   PCBOARDX;

typedef struct
{
	unsigned    ww4_speed;
	short   ww4_usernum;
	short   ww4_age;
	short   ww4_level;
	BOOL    ww4_cosysop;
	short   ww4_incom;
	char    ww4_user[33];
	char    ww4_name[33];
	char    ww4_sex;
	char    ww4_textfiles[65];
	char    ww4_datafiles[65];
	char    ww4_logfile[65];
	float   ww4_gold;
}   WWIV;

typedef struct
{
	short   ds_node;
	BOOL    ds_display;
	BOOL    ds_page;
	BOOL    ds_printer;
	BOOL    ds_alarm;
	char    ds_name[33];
	char    ds_from[33];
	char    ds_voice[17];
	char    ds_data[17];
	char    ds_password[17];
	short   ds_level;
	short   ds_logins;
	short   ds_time_quota;
	BOOL    ds_expert_mode;
	short   ds_conference;
	BYTE    ds_joined[8];
	char    ds_expire[8];
	short   ds_usernum;
	char    ds_protocol;
	short   ds_downloads;
	short   ds_uploads;
	short   ds_download_quota;
	short   ds_download_used;
}   DOORSYS;

typedef struct
{
	DOOR_TYPE   door_type;
	FILE        *door_fp;
	time_t      door_since;
	time_t      door_expire;
	unsigned    door_speed;
	BOOL        door_sysop;
	BOOL        door_color;
	short       door_rows,door_cols;
	short       door_port;

	union
	{
		PCBOARD pcboard;
		WWIV    wwiv;
		DOORSYS doorsys;
	}   door;
}   DOORINFO;

/*  Import from doorlib */

extern  DOORINFO    doorinfo;

extern  BOOL    PASCAL opendoor(char *fname);
extern  char    *PASCAL get_door_line(int skip, FILE *fp);
extern  short   PASCAL getuid(void);
extern  short   PASCAL getgid(void);
extern  char    *PASCAL get_name(void);
extern  void    noansi(void);

extern  BOOL    PASCAL  wwiv_setup(char *fname);

