/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  exit.c                                                       */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <unistd.h>
#include <ntape.h>

/*************************************************************************/
/* Name:     nta_exit                                                    */
/* Purpose:  End of Programm: Restore old terminal behavior              */
/*************************************************************************/
void nta_exit(int ret)
{
/* Abschluss von ncurses */
/*    erase();
      refresh(); */

    endwin();

    /* Fork ntape and the son rewinds tape. So we don't have to wait for it. */
    if (fork() <= 0)     /* Son or fork not successful */
    {
	if (!offline())
	    do_tape_command("rewind",0);
    }
    exit(ret);
}


/*************************************************************************/
/* Copyright (C) 1994,1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
