/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  initscr.c                                                    */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <stdio.h>
#include <ntape.h>

WINDOW *std,*menu,*foot,*listbox,*tapestatus;


/*************************************************************************/
/* Name:     nta_initscr                                                 */
/* Purpose:  Initialize screen                                           */
/*************************************************************************/
void nta_initscr()
{
    /* Initialise ncurses screen */
    std = initscr();
    leaveok(std,TRUE);
    keypad(std,TRUE);
  
    /* Screen big enough ? */
    if (COLS < MINCOL || LINES < MINLINES)
    {
	fprintf(stderr,"Sorry! Your terminal is too small! Exiting...\n");
	exit(1);
    }
 
    if (has_colors())
	start_color();

    noecho();
    cbreak();

    /* We need a menu */
    menu = newwin(1,COLS,0,0);
    leaveok(menu,TRUE);
    keypad(menu,TRUE);
    set_color_pair(menu,MENU);
    print_menu();

    /* And a foot line */
    foot = newwin(1,COLS,LINES-1,0);
    leaveok(foot,TRUE);
    keypad(foot,TRUE);
    set_color_pair(foot,FOOTER);
    print_version();

    /* Don't forget a tape status line */
    tapestatus = newwin(1,COLS,1,0);
    leaveok(tapestatus,TRUE);
    keypad(tapestatus,TRUE);
    set_color_pair(tapestatus,STATUSLINE);
    mvwaddstr(tapestatus,0,0,"");
    winclrtoeol(tapestatus);
    touchwin(tapestatus);
    wrefresh(tapestatus);

    /* And last but not least the listbox */
    listbox = newwin(LINES-3,COLS,2,0);
    leaveok(listbox,TRUE);
    keypad(listbox,TRUE);
    set_color_pair(listbox,ARCHIVELIST);
}


/*************************************************************************/
/* Copyright (C) 1994,1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
