/*
 * Copyright (c) Des Herriott 1993, 1994
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the copyright holder not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The copyright holder makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Martin Smith (msmith@lssec.bt.co.uk)
 */

/*
 * Definitions for the Interface 1 Emulation.
 *
 * By Martin H. Smith
 *
 * 12th March 1994
 */

/*
 * I recommend you set KEEP_DRIVES_IN_RAM to at least 2 so that MOVE operations
 * and copying files between drives can be done efficiently.
 */

#define MAX_DRIVES 8					/* how many drives are there? */
#define KEEP_DRIVES_IN_RAM 2			/* number to keep cached */

/*
 * SHADOW_ROM_SIZE is the size of the second ROM. This ROM is activated by
 * an instruction fetch on 0x0008 (multi purpose entry point) or 0x1708
 * (close routine) and switched out by a fetch on 0x0700 in the new ROM.
 */

#define SHADOW_ROM_SIZE 8192

/*
 * CART_FILE_SIZE is the size in bytes of a .MDR cartridge file
 *
 * CART_FILE_SECTOR_SIZE is the notional sector size of the sectors stored in
 * the file, excluding the preamble. The software does not take much account
 * of sectors.
 *
 * CART_FILE_NUM_SECTORS is the no of sectors and the 1 byte difference
 * between the file size and the product of the number of sectors and sector
 * size is the write prot flag at the end of the file (non zero means hands 
 * off!)
 */

#define CART_FILE_SIZE 137923
#define CART_FILE_SECTOR_SIZE 543
#define CART_FILE_NUM_SECTORS 254

/*
 * Port EF input bits, used to determine microdrive status.
 *
 * The GAP bit toggles as a GAP (blank tape) passes the head. Regular GAPS
 * occurring means the drive is running with a cartridge inserted.
 *
 * The SYNC bit is vital to the operation of the drives. It goes low just as
 * the end of the preamble passes the head and provides read / write
 * synchronisation of the serial data stream.
 *
 * The WRITE_PROT bit is low if there is a cartridge in the drive which is
 * write protected.
 */

#define WRITE_PROT_BIT 1
#define SYNC_BIT 2
#define GAP_BIT 4
#define DTR_BIT 8
#define BUSY_BIT 16

/*
 * How often we toggle the GAP line
 */

#define GAP_CLOCK_RATE 10

/*
 * Port EF output bits. Used to control the drives.
 *
 * The COMMS_DATA and COMMS_CLOCK bit are used to select drives. Stepping the
 * clock counts through drives and the data bit turning on or off the
 * appropriate drive motor. On a real IF 1 you can turn on more than one
 * drive at once by OUTING to the port, the emulator does not allow this.
 *
 * The RW and ERASE bits are used to select the mode, reading, writing or
 * erasing tape.
 */

#define COMMS_DATA_BIT 1
#define COMMS_CLK_BIT 2
#define RW_BIT 4
#define ERASE_BIT 8
#define CTS_BIT 16
#define WAIT_BIT 32


/*
 * Used to hold information on each drive
 */

typedef struct drivedata

{
	int fd;								/* file descriptor of cartridge file
										   or -1 */
	long tapepos;						/* tape head R/W pos */
	int loaded;							/* cartridge in ? */
	int protect;						/* write protected ? */
	int dirty;							/* cartridge file needs an update? */
	long sequence;						/* cache sequence number */
	char *filename;						/* name of cartridge file */
	uns8 *buffer;						/* cartridge data buffer */
} mdrive_data, *mdrive_data_ptr;

/*
 * Definitions for 'RS232' emulation. This basically connects the 'T' and 'B'
 * channels to stdio. You must use the supplied ROM image for this to work.
 */

#define RS232_IP_ADDRESS 0x0b9a
#define RS232_OP_ADDRESS 0x0c5a

#define RS232_IP_BPT_BYTE 0xf3
#define RS232_OP_BPT_BYTE 0x06

#define RS232_IP_BPT 0xfe
#define RS232_OP_BPT 0xff

