/*
 * Copyright (c) Des Herriott 1993, 1994
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the copyright holder not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The copyright holder makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 */

/*
 * Header module spectrum.h - some hardware and X11 definitions.
 */


/* Pixel sizes of 1, 2, 3 and 4 are supported.  Be warned -
 * sizes > 2 will significantly slow down the emulator.
 */
#ifndef SCALING
#define SCALING 1
#endif
#define HSize (256 * SCALING)
#define VSize (192 * SCALING)
#define BORDER_WIDTH (30 * SCALING)

/* Indices into the dtbl lookup table: */
/* dtbl[addr][XVal] => X co-ordinate in display file of addr */
/* dtbl[addr][YVal] => Y co-ordinate */
#define XVal 0
#define YVal 1
extern unsigned char dtbl[6144][2];	/* from dtbl.c */

/* Map an (x,y) pixel coordinate to a offset into the attribute area */
#define XYToAttr(x,y) (((x) >> 3) + ((y & 0xf8) << 2))

/* These macros map a byte in the attribute area to an X11 pixel value */
#define Background(byte) (((byte) & 0x38) >> 3) | (((byte) & 0x40) >> 3)
#define Foreground(byte) ((byte) & 0x07) | (((byte) & 0x40) >> 3)

/* 8 colour cells for the standard colours, 8 for the brightened versions.  */
#define NCOLORS 16

/* Adresses of display and attribute areas */
#define D_FILE 0x4000
#define A_FILE 0x5800

/* Pseudo I/O ports which talk to stdin, stdout & stderr on Unix
 * PSEUDO_IO_SELECT is the low byte of the port address, the other
 * three defines are the high byte.  So, reading port BF00 takes a
 * byte from stdin, writing BF01 sends a byte to stdout, and so on.
 */
#ifdef PSEUDO_IO
#define PSEUDO_IO_SELECT 0xbf
#define STDIN_PSEUDO_PORT 0
#define STDOUT_PSEUDO_PORT 1
#define STDERR_PSEUDO_PORT 2
#endif

