/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: misc.c,v 3.9.2.0 1995/06/12 17:14:03 mj Exp $
 *
 * Miscellaneous functions
 *
 *****************************************************************************
 * Copyright (C) 1990-1995
 *  _____ _____
 * |	 |___  |   Martin Junius	     FIDO:	2:2452/110.1
 * | | | |   | |   Republikplatz 3	     Internet:	mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:	++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"



/*
 * Secure string functions:
 *
 * str_copy  (d,n,s)              - copy string
 * str_copy2 (d,n,s1,s2)          - copy concatenation of 2 strings
 * str_copy3 (d,n,s1,s2,s3)       - copy concatenation of 3 strings
 * str_copy4 (d,n,s1,s2,s3,s4)    - copy concatenation of 4 strings
 * str_copy5 (d,n,s1,s2,s3,s4,s5) - copy concatenation of 5 strings
 * str_append(d,n,s)              - append string
 *
 * d = destination buffer
 * n = destination size
 */
char *str_copy(d, n, s)
    char *d;
    size_t n;
    char *s;
{
    strncpy(d, s, n);
    d[n-1] = 0;
    return d;
}

char *str_append(d, n, s)    
    char *d;
    size_t n;
    char *s;
{
    int max = n - strlen(d) - 1;
    strncat(d, s, max);
    d[n-1] = 0;
    return d;
}    

char *str_copy2(d, n, s1, s2)
    char *d;
    size_t n;
    char *s1;
    char *s2;
{
    str_copy  (d, n, s1);
    str_append(d, n, s2);
    return d;
}

char *str_copy3(d, n, s1, s2, s3)
    char *d;
    size_t n;
    char *s1;
    char *s2;
    char *s3;
{
    str_copy  (d, n, s1);
    str_append(d, n, s2);
    str_append(d, n, s3);
    return d;
}

char *str_copy4(d, n, s1, s2, s3, s4)
    char *d;
    size_t n;
    char *s1;
    char *s2;
    char *s3;
    char *s4;
{
    str_copy  (d, n, s1);
    str_append(d, n, s2);
    str_append(d, n, s3);
    str_append(d, n, s4);
    return d;
}

char *str_copy5(d, n, s1, s2, s3, s4, s5)
    char *d;
    size_t n;
    char *s1;
    char *s2;
    char *s3;
    char *s4;
    char *s5;
{
    str_copy  (d, n, s1);
    str_append(d, n, s2);
    str_append(d, n, s3);
    str_append(d, n, s4);
    str_append(d, n, s5);
    return d;
}

    

/*
 * strncpy0() --- strncpy() with terminating '\0' char
 */
char *strncpy0(d, s, n)
    char *d, *s;
    int n;
{
    strncpy(d, s, n);
    d[n-1] = 0;
    return d;
}



/*
 * strncat0() --- strncat() with terminating '\0' char and
 *                n == destination buffer size
 */
char *strncat0(d, s, n)
    char *d, *s;
    int n;
{
    int max = n - strlen(d) - 1;
    strncat(d, s, max);
    d[n-1] = 0;
    return d;
}    


    
#if !defined(DO_HAVE_STRCASECMP) && !defined(DO_HAVE_STRICMP)
/***** strnicmp() --- compare n chars of strings ignoring case ***************/

int strnicmp(sa, sb, len)
    char *sa, *sb;
    int len;
{
    while(len--)
	if(tolower(*sa) == tolower(*sb)) {
	    sa++;
	    sb++;
	}
	else if(tolower(*sa) < tolower(*sb))
	    return(-1);
	else
	    return(1);
    return(0);
}



/***** stricmp() --- compare strings ignoring case ***************************/

int stricmp(sa, sb)
    char *sa, *sb;
{
    while(tolower(*sa) == tolower(*sb)) {
	if(!*sa)
	    return(0);
	sa++;
	sb++;
    }
    return(tolower(*sa) - tolower(*sb));
}
#endif /**!DO_HAVE_STRCASECMP && !DO_HAVE_STRICMP**/



/*
 * Remove \r\n from end of line
 */
void strip_crlf(line)
    char *line;
{
    int len;
    
    len = strlen(line);
    if( line[len-1] == '\n' )
	line[len-1] = 0;
    
    len = strlen(line);
    if( line[len-1] == '\r' )
	line[len-1] = 0;
}



/*
 * Remove white space at end of line
 */
void strip_space(line)
    char *line;
{
    int i;
    
    for(i=strlen(line)-1; i>=0; i--)
	if(is_space(line[i]))
	    line[i] = 0;
	else
	    break;
}



/*
 * isspace() replacement, checking for SPACE, TAB, CR, LF
 */
int is_space(c)
    int c;
{
    return c==' ' || c=='\t' || c=='\r' || c=='\n';
}


/*
 * checking for SPACE or TAB
 */
int is_blank(c)
    int c;
{
    return c==' ' || c=='\t';
}



/*
 * Expand %X at start of file names
 *
 * %S    SPOOLDIR
 * %L    LIBDIR
 * %O    LOGDIR
 */
char *str_expand_name(d, n, s)
    char *d;
    size_t n;
    char *s;
{
    d[0] = 0;

    if(s[0] == '%')
    {
	switch(s[1])
	{
	case 'S':				/* Spooldir */
	    str_append(d, n, cf_spooldir());
	    s += 2;
	    break;
	case 'L':				/* Libdir */
	    str_append(d, n, cf_libdir());
	    s += 2;
	    break;
	case 'O':				/* Logdir */
	    str_append(d, n, cf_logdir());
	    s += 2;
	    break;
	}
    }
    
    str_append(d, n, s);
    
    return d;
}
