/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FTN NetMail/EchoMail
 *
 * $Id: tick.c,v 3.9.2.0 1995/06/12 17:14:03 mj Exp $
 *
 * TIC file processing
 *
 *****************************************************************************
 * Copyright (C) 1990-1995
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"



/*****FIXME: move to structs.h*****/

typedef struct st_tick 		/* .TIC file description, see also FSC-0028 */
{
    Node     origin;			/* Origin address */
    Node     from;			/* From (this tic) address */
    Node     to;			/* To (this tic) addresss */
    char    *area;			/* Area name */
    char    *file;			/* File name */
    Textlist desc;			/* Description (multiple lines) */
    unsigned long crc;			/* File CRC32 checksum */
    char    *created;			/* Creator */
    unsigned long size;			/* File size */
    LON      path;			/* Path */
    LON      seenby;			/* Seenby */
    char    *pw;			/* Password */
    time_t   release;			/* Release date */
    time_t   date;			/* File date */
    Textlist app;			/* Application specific */
}
Tick;



/*
 * Init Tick struct
 */
void tick_init(tic)
    Tick *tic;
{
    node_invalid(&tic->origin);
    node_invalid(&tic->from);
    node_invalid(&tic->to);
    tic->area = NULL;
    tic->file = NULL;
    tl_init(&tic->desc);
    tic->crc = 0;
    tic->created = NULL;
    tic->size = 0;
    lon_init(&tic->path);
    lon_init(&tic->seenby);
    tic->pw = 0;
    tic->release = -1;
    tic->date = -1;
    tl_init(&tic->app);
}



/*
 * Delete Tick struct
 */
void tick_delete(tic)
    Tick *tic;
{
    node_invalid(&tic->origin);
    node_invalid(&tic->from);
    node_invalid(&tic->to);
    xfree(tic->area);
    tic->area = NULL;
    xfree(tic->file);
    tic->file = NULL;
    tl_clear(&tic->desc);
    tic->crc = 0;
    xfree(tic->created);
    tic->created = NULL;
    tic->size = 0;
    lon_delete(&tic->path);
    lon_delete(&tic->seenby);
    xfree(tic->pw);
    tic->pw = NULL;
    tic->release = -1;
    tic->date = -1;
    tl_clear(&tic->app);
}
    
