#include "protocol.h"
#include "bootinc.h"

/* Originally part of NCSA Telnet
   Modified by Jamie Honan
*/

static ARPKT arp;

static int
replyarp(uint8 *thardware, uint8 *tipnum)
{
	uint8 *pc;

	memcpy(&arp.d, &blankd, sizeof(DLAYER));
	arp.d.type = EARP;			/* 0x0806 is ARP type */
	arp.hrd = intswap(HTYPE);			/*  Ether=1 */
	arp.pro = intswap(ARPPRO);		/* IP protocol=0x0800 */
	arp.hln = DADDLEN;			/* Ethernet hardware length */
	arp.pln = 4;				/* IP length=4 */
	memcpy(arp.sha, nnmyaddr, DADDLEN);	/* sender's hardware addr */
	memcpy(arp.spa, nnipnum, 4);		/* sender's IP addr */

	memcpy(arp.tha, thardware, DADDLEN);   /* who this goes to */
	memcpy(arp.tpa, tipnum, 4);		/* requester's IP address */
	arp.op=intswap(ARPREP);			/* byte swapped reply opcode */
	memcpy(arp.d.dest, thardware, DADDLEN);	/* hardware place to send to */
	dlayersend((DLAYER *)&arp,sizeof(arp));
	return(0);		/* ARP ok */
}

int arpinterpret(ARPKT *p)
{
/*
*  check packet's desired IP address translation to see if it wants
*  me to answer.
*/
	if(p->op == intswap(ARPREQ) && (!memcmp(p->tpa, nnipnum, 4)))
	{ 
		/* check for conflicting IP number with your own */
		if(!memcmp(p->spa, nnipnum, 4))	
		{
			 /* we are in trouble */
			 /* sender's ip is same as our's */
			n_printf("Conflicting Ethernet address: %x:%x:%x:%x:%x:%x\n",
				p->sha[0],
				p->sha[1],
				p->sha[2],
				p->sha[3],
				p->sha[4],
				p->sha[5]);
			return -102;
		}
		replyarp(p->sha, p->spa);		/* proper reply */
	}
	return(0);
}


