/*
 *	UDP.C
 *	UDP Protocol Routines
 *
 *	Revision history:
 *	JWH Apr 93 - substantial changes
 *
 *	This was originally part of NCSA Telnet but
 *	has undergone substantial modification     
 */

#include "protocol.h"
#include "bootinc.h"

void 
dldump(DLAYER * p)
{
	n_printf("dest=%x.%x.%x.%x.%x.%x  me=%x.%x.%x.%x.%x.%x type %d\n",
	       p->dest[0], p->dest[1], p->dest[2], p->dest[3], p->dest[4], p->dest[5],
	       p->me[0], p->me[1], p->me[2], p->me[3], p->me[4], p->me[5],
	       p->type);
}


void 
udpdump(UDPKT * p)
{
	n_printf("Dest port %d, source port %d length %d\n", intswap(p->u.dest), intswap(p->u.source), intswap(p->u.length));
}

/*
 *	udprecv ( p, port )
 *
 *	Take an incoming UDP packet and make the available to the user level
 * routines.  Currently keeps the last packet coming in to a port.
 *
 *	Limitations :
 *
 * Can only listen to one UDP port at a time, only saves the last packet
 * received on that port.  Port numbers should be assigned like TCP ports.
 *
 * returns length if packet available, 0 if not
 */
int 
udprecv(p, uport)
UDPKT          *p;
uint            uport;
{
	uint            hischeck,
	                mycheck;
	int             ulen;
	int 		code;

	ulen = iprecv((IPKT *) p);
	if (!ulen)
		return 0;
	if (ulen < 0)
		return ulen;
	if (debug)
		dldump((DLAYER *) p);
/*
 *  did we want this data ?  If not, then let it go, no comment
 *  If we want it, copy the relevent information into our structure
 */
	if (intswap(p->u.dest) != uport)
		return (0);
/*
 *  first compute the checksum to see if it is a valid packet
 */
	hischeck = p->u.check;
	p->u.check = 0;
	if (hischeck)
	{
		memcpy(tcps.source, p->i.ipsource, 8);
		tcps.z = 0;
		tcps.proto = p->i.protocol;
		tcps.tcplen = intswap(ulen);
		mycheck = tcpcheck((char *) &tcps, (char *) &p->u, ulen);
		if (hischeck != mycheck)
		{
			netposterr(700);
			return (0);
		}
		p->u.check = hischeck;	/* put it back */
	}
	ulen -= 8;	/* account for header */
	if (ulen > UMAXLEN)	/* most data that we can accept */
		ulen = UMAXLEN;
	return (ulen);
}

/*
 *	netusend ( machine, eaddr, port, retport, buffer, n )
 *
 *	Send some data out in a udp packet ( uses the preinitialized data in the
 * port packet *ulist.udpout* )
 *
 *	Returns 0 on ok send, non-zero for an error
 *
 */

int 
netusend(machine, eaddr, port, retport, buffer, n)
unsigned char  *machine,
               *buffer,
               *eaddr;
uint            port,
                retport;
int             n;
{

	if (n > UMAXLEN)
		n = UMAXLEN;
/*
 *  make sure that we have the right dlayer address
 */
	memcpy(udpout.d.me, nnmyaddr, DADDLEN);
	memcpy(udpout.d.dest, eaddr, DADDLEN);
	memcpy(udpout.i.ipdest, machine, 4);
	memcpy(utcps.dest, machine, 4);
	udpout.u.dest = intswap(port);
	udpout.u.source = intswap(retport);
	utcps.tcplen = udpout.u.length = intswap(n + sizeof(UDPLAYER));
	memcpy(udpout.data, buffer, n);
/*
 *  put in checksum
 */
	udpout.u.check = 0;
	udpout.u.check = tcpcheck((char *) &utcps, (char *) &udpout.u, n + sizeof(UDPLAYER));
/*
 *   iplayer for send
 */
	udpout.i.tlen = intswap(n + sizeof(IPLAYER) + sizeof(UDPLAYER));
	udpout.i.ident = intswap(nnipident++);
	udpout.i.check = 0;
	udpout.i.check = ipcheck((char *) &udpout.i, 10);
/*
 *  send it
 */
	if (debug)
	{
		n_printf("Sending....\n");
		dldump((DLAYER *) & udpout);
		ipdump((IPKT *) & udpout);
		udpdump(&udpout);
	}

	return (dlayersend((DLAYER *) & udpout, sizeof(DLAYER) + sizeof(IPLAYER) + sizeof(UDPLAYER) + n));
}
