#
#	Common Sub-Makefile for the MMDF System
#
HOST		= linux
SYSTEM		= 4.2
MMPREF		=
LIBDIR		= /usr/lib/mail/bin
CHANDIR		= /usr/lib/mail/bin
TBLDIR		= /usr/lib/mail/table
BINDIR		= /usr/lib/mail/bin
RCVDIR		= /usr/lib/mail/bin

#
#  Defines used during installation
#
INSTALL		= install
CHOWN		= chown
MMDFLOGIN	= mail
ROOTLOGIN	= root
PGMPROT 	= 775

#
#  Configuration Defines
#
#  See the document "Installing and Operating MMDF II" for descriptions
#  of the available CONFIGDEFS options.
#  (The paths below are relative from the individual source directories.)
#
CONFIGDEFS	= -DDEBUG=2 -DV4_2BSD -DNAMESERVER -DD_LOG -DD_DBGLOG -DUUCPLOCK -DNODOMLIT -DNODIAL
CFLAGS		= -g -DLINUX -I../../h $(CONFIGDEFS)
LDFLAGS 	=
MMDFLIBS 	= ../../lib/libmmdf.a
SYSLIBS		= -ldbm -lbsd
LINT		= echo
LFLAGS		= -bxaL -I../../h $(CONFIGDEFS)
LLIBS		= ../../lib/llib-lmmdf.ln
AR		= ar


#  Specify either ch_tbdbm (for DBM based tables) or ch_tbseq for
#  sequential IO based tables.
CH_TB	= ch_tbseq

#  Specify one of the nameserver modules or the fake module
#  if you do not intend to support nameservers (4.2, fake)
TB_NS	= 4.2

#  Specify tai_???.o and lk_lock???.o
LOCALUTIL = tai_file.o lk_lock.4.2.o


default:	real-default

.c.o:
	$(CC) $(CFLAGS) $(TARGET_ARCH) -c $<

#
#  special case dependencies
#
../../h/mmdf.h:	../../h/conf.h
	@touch ../../h/mmdf.h
