/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_FCNTL
#define IS_STAT
#define IS_STDIO
#define IS_STRING
#define IS_TYPES
#define IS_UNISTD

#include "config.h"
#include "includes.h"
#include "prototypes.h"


/* This routine checks if "from" matches a regulare expression either
 * in the allow or the deny file.
 *
 * If a user is not listed in the allow file, but an allow file exists,
 * or the user is listed in a deny file, then 0 is returned, otherwise
 * 1 is returned.
 */

int checkforself(char *whoami, char *from, char *to){
  int j;
  static char *hostname[NNAMES+1] = { HOSTNAMES ,"localhost"};

/* Check if this mail was really intended for me. */
  if(whoami==NULL) return 1;
  if(to!=NULL){
    if(strlen(to)>0){
      char To[LINESIZE], *s, *t;
      for(s=parseaddress(to,&t);s!=NULL;s=parseaddress(t,&t)){
        if(!strcasecmp(s,whoami)) break;
        if(strlen(s)>0){
          for(j=0;j<NNAMES+1;j++)
            if(usercmp(s,whoami,hostname[j])) break;
          if(j<NNAMES+1) break;
        };
      };
      if(s==NULL) return 0;
    };
  };

  if(from==NULL) return 1;

/* This is just to check I'm not mailing myself */

  for(j=0;j<NNAMES+1;j++)
    if(usercmp(from,whoami,hostname[j])) return 0;
  return 1;
}

