/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_STDLIB

#include "config.h"
#include "includes.h"
#include "prototypes.h"


void daemonputenv(char *queuedir,char *mailbox,char *queue,char *user,
  char *home){
  char *path,variable[LINESIZE];

  path=getenv("PATH");
  if(hash(path,"gzip")==NULL||hash(path,"daemon")==NULL){
    char *t;

    path=PATH;
    sprintf(variable,"PATH=%s",path);
    for(t=index(variable,'~');t!=NULL;t=index(++t,'~')){
      path=index(path,'~');
      if(index("=:",*(t-1))!=NULL)
        sprintf(t,"%s%s",home,++path);
      else
        path++;
    };
    putenv(variable);
  };

  if(queuedir [0] == '~')
    sprintf(variable,"QUEUEDIR=%s%s",home,&queuedir[1]);
  else
    sprintf(variable,"QUEUEDIR=%s",queuedir);
  putenv(variable);

  sprintf(variable,"MAILBOX=%s",mailbox);
  putenv(variable);

  sprintf(variable,"QUEUE=%s",queue);
  putenv(variable);

  sprintf(variable,"USER=%s",user);
  putenv(variable);

  sprintf(variable,"HOME=%s",home);
  putenv(variable);

  sprintf(variable,"RECEIVE=%s",RECEIVE);
  putenv(variable);

  sprintf(variable,"OUTGOING=%s",OUTGOING);
  putenv(variable);

  sprintf(variable,"SIGALRM=%d",SIGALRM);
  putenv(variable);

  sprintf(variable,"SIGTERM=%d",SIGTERM);
  putenv(variable);
}

