/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_STDIO
#define IS_UNISTD

#include "config.h"
#include "includes.h"


/* This is an attempt to fixed messed up stdin, stdout and stderr references.
 * I find open() and fopen() will happily reassign 0,1, and 2 if I leave them
 * closed.  Then if I exec to something, it may take that file as being stdin,
 * stdout, or stderr...
 */
FILE *fstdio[3];

void fstdioopen(void){
  FILE *fnull;
  int i;

  fstdio[0]=stdin;
  fstdio[1]=stdout;
  fstdio[2]=stderr;

  do{
    fnull=fopen("/dev/null","r+");
  }while(fileno(fnull)<3 && fileno(fnull)>-1);
  fclose(fnull);

  for(i=0;i<3;i++)if(fstdio[i]!=NULL){
    if(fileno(fstdio[i])!=i){
      if(fileno(fstdio[i])>2){
        close(i);
        dup2(fileno(fstdio[i]),i);
        close(fileno(fstdio[i]));
        fclose(fstdio[i]);
      };
      fstdio[i]=fdopen(i,(i==0) ? "r" : "w");
    };
  }else{
    fstdio[i]=fdopen(i,(i==0) ? "r" : "w");
  };
}

