/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_GETOPT
#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_PWD

#include "config.h"
#include "includes.h"
#include "readline.h"
#include "mailflags.h"
#include "prototypes.h"


void main(int argc, char *argv[]) {
  struct BFILE input;
  int max_size=MAXSIZE,failed=0,debug=0;
  long flags=0;
  char c, from[LINESIZE], reply[LINESIZE], to[LINESIZE], mailbox[LINESIZE];
  char *subject[LINESIZE];
  char file[LINESIZE]; 
  int nsubjects=0,hops=0;
  char *home,*user,*basedir=NULL,*logfile=LOGFILE;

  fstdioopen();

  input.fd=fstdio[0];
  input.NR=0;
  mailbox[0]='\0';
  {
    struct passwd *pw;
    pw=getpwuid(getuid());
    home=pw->pw_dir;
    user=pw->pw_name;
  };

  while ((c = getopt (argc, argv, "b:df:i:l:m:p:qsto:v")) != EOF){
    switch (c) {
      case 'b':  /* This is the directory to read from */
#ifdef USE_QUEUE
        basedir=optarg;
#else
        failed=1;
#endif
        break;
      case 'd':
        debug=1;
        break;
      case 'f':
        { char forward[LINESIZE];
          sprintf(forward,"GETMAIL_FORWARD=%s",optarg);
          putenv(forward);
        };
	break;
      case 'i':  /* Use a file instead of standard input */
        close(0);
        input.fd=freopen(optarg,"r",input.fd);
        if(fileno(input.fd)!=0)
          dup2(fileno(input.fd),0);
        break;
      case 'q':  /* Use quote mode, handy for debugging */
        flags |= MF_PROCESSED;
        break;
      case 'l':
        logfile=optarg;
        break;
      case 'm':  /* Maximum ascii file size */
#ifdef USE_QUEUE
        max_size=atoi(optarg);
        if(index(optarg,'k')!=NULL
           || (index(optarg,'b')==NULL && max_size<1024))
	   max_size*=1024;
#else
        failed=1;
#endif
        break;
      case 'o':  /* Use a different mailbox */
	if(*optarg == '~')
	  sprintf(mailbox,"%s%s",home,optarg);
	else
          strcpy(mailbox,optarg);
        break;
      case 'p':  /* SMTP service to use */
        { char smtpservice[LINESIZE];
          sprintf(smtpservice,"SMTPSERVICE=%s",optarg);
          putenv(smtpservice);
        };
        break; 
      case 's':  /* Silent default */
        debug=0;
        break;
      case 't':  /* Forward with term */
#ifdef USE_TERM
	flags |= MF_FORTERM;
#else
        failed=1;
#endif
	break;
      case 'v': /* Print version */
        version();
        exit(0);
      default:
        failed=1;
    };
  };

#ifdef DEBUG 
  fprintf(fstdio[1],"figuring out logfile \n");
  fflush(fstdio[1]);
#endif

  if(logfile[0]=='~')
    sprintf(file,"%s%s.%s",home,&logfile[1],LOG_EXT);
  else if(logfile[0]=='/')
    sprintf(file,"%s.%s",logfile,LOG_EXT);
  else if(QUEUEDIR[0]=='~')
    sprintf(file,"%s%s/%s.%s",home,&QUEUEDIR[1],logfile,LOG_EXT);
  else
    sprintf(file,"%s/%s.%s",QUEUEDIR,logfile,LOG_EXT);

  if(debug)
    fprintf(fstdio[1],"Would have opened %s\n",file);
  else{
    close(2);
    freopen(file,"a",fstdio[2]);
    close(1);
    freopen("/dev/null","w",fstdio[1]);
  };

  fprintf(fstdio[1],"%s\n","getmail: running");
  if(failed)
      fprintf(fstdio[2],"Usage: getmail [-o mailbox] [-m <size>] [-b <base directory>]\n");

  if(!mailbox[0]){
    if(MAILBOX [0] == '~')
      sprintf(mailbox,"%s%s",home,&MAILBOX[1]);
    else
      sprintf(mailbox,"%s/%s",MAILBOX,user);
  };

#ifdef DEBUG
  fprintf(fstdio[1],"Entering main\n");
  fflush(fstdio[1]);
#endif
  nsubjects = parseheader(&input,from,reply,to,subject,&hops);

/* This is usefull for when I forward mail. */

  if(nsubjects<0){
    if(!strcmp(subject[0],C_FLUSH))
      mailme(&input,mailbox,home,MF_COMMAND|MF_RECEIVE|flags);
    else if(!strcmp(subject[0],C_FORWARD))
      mailme(&input,mailbox,home,MF_COMMAND|MF_PRIVATE|MF_RECEIVE|flags|MF_FORWARD);
    else
      mailme(&input,mailbox,home,MF_COMMAND|MF_RECEIVE|flags);
  }else if(nsubjects>0){
    if(!strcmp(subject[0],C_FORWARD))
      mailme(&input,mailbox,home,MF_PRIVATE|MF_RECEIVE|flags|MF_FORWARD);
  }; 
 
/* Those are the only subjects I check if I don't need to queue files. */ 
/* If the hop count is greater than 0, don't process this request.... */
 
#ifdef USE_QUEUE
  if(failed||basedir==NULL)
#endif
    mailme(&input,mailbox,home,MF_NOBASEDIR|MF_PRIVATE|MF_RECEIVE|flags);

#ifdef USE_QUEUE
  if(hops>0)
    mailme(&input,mailbox,home,MF_HOPS|MF_PRIVATE|MF_RECEIVE|flags);

/* These are special users I should never automatically reply */

  if( !from[0] )
    mailme(&input,mailbox,home,MF_UNKNOWN|MF_PRIVATE|MF_RECEIVE|flags);

/* These are special subjects I should never automatically reply */

  if(nsubjects>=1)
    if( !strcmp(subject[0],"re:") 
        || !strcmp(subject[0],"forward") 
        || !strcmp(subject[0],"bounce") 
        || !strcmp(subject[0],"returned") 
        || !strcmp(subject[0],"private") 
        || !strcmp(subject[0],"silent") 
        || !strcmp(subject[0],"bugs")
        || !strcmp(subject[0],"incoming")
      ) mailme(&input,mailbox,home,MF_SPECIAL|MF_PRIVATE|MF_RECEIVE|flags);

/* Finailly I check access writes */

  if(!checkforself(user,reply,NULL))
    mailme(&input,mailbox,home,MF_SELF|MF_PRIVATE|MF_RECEIVE|flags);
  if(!checkforself(user,NULL,to))
    mailme(&input,mailbox,home,MF_NOTOACCESS|MF_PRIVATE|MF_RECEIVE|flags);
  if(!checkaccess(home,from,NULL,NULL))
    mailme(&input,mailbox,home,MF_NOFROMACCESS|MF_PRIVATE|MF_RECEIVE|flags);
  if(!checkaccess(home,reply,NULL,NULL))
    mailme(&input,mailbox,home,MF_NOREPLYACCESS|MF_PRIVATE|MF_RECEIVE|flags);
 
/* Queue the requested files and mailme. */

  mailme(&input,mailbox,home,MF_TRIED|queuefiles(nsubjects,subject,reply,home,
    basedir, max_size)|flags);

#endif /* USE_QUEUE */

  exit(1); /* mailme should never return */
}

