/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef  READ_CONFIG
#include config.h
#endif

#ifdef __hpux
#define _INCLUDE_HPUX_SOURCE
#define _INCLUDE_POSIX_SOURCE
#define _INCLUDE_XOPEN_SOURCE
#endif

/* This was taken from Michael O'Reilly's "Term 1.14" */

#ifdef IS_GETOPT
#if defined(linux)
#include <getopt.h>
#elif defined(__hpux) || defined(__386BSD__) || defined(___386BSD___) || defined(SVR4) || defined(__NetBSD__) || defined(__OSF1__) || defined(__osf__) 
#if defined(__hpux__) || defined(__hpux) 
extern char *optarg;
extern int optind, opterr;
#endif
/* Do nothing -- declared in stdlib.h */
#else
int getopt(int argc, char *argv[], char *);
extern char *optarg;
extern int optind, opterr;
#endif
#endif

#ifdef IS_ERRNO
#include <errno.h>
#endif

#ifdef IS_TYPES
#include <sys/types.h>
#endif

#ifdef IS_FCNTL
#include <fcntl.h>
#endif

#ifdef IS_STDIO
#include <stdio.h>
extern FILE *fstdio[3];
#endif

#ifdef IS_STDLIB
#ifdef linux
#include <stdlib.h>
#endif
#endif

#ifdef IS_UNISTD
#include <unistd.h>
#endif

#ifdef IS_SIGNAL
#include <signal.h>
#endif

#ifdef IS_STRING
#include <string.h>
#include <strings.h>
#endif

#ifdef IS_STAT
#include <sys/stat.h>
#endif

#ifdef IS_PWD
#include <pwd.h>
#endif

#ifdef IS_SOCKET
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#endif

#ifdef IS_TIME
#include <time.h>
#include <sys/timeb.h>
#endif

#ifdef IS_REGEX
#ifdef USE_STEP
#define INIT   register char *sp = instring; char cregexp,iregexp='\0';
#define GETC() 	    (!iregexp ? *sp++ : (cregexp+(iregexp='\0')))
#define PEEKC()     (!iregexp ? *sp : cregexp)
#define UNGETC(c)   (cregexp=(c)+(iregexp='\1')-'\1')
#define RETURN(c)   return (c);
#define ERROR(c)    exit((c));
#include <regexp.h>
#else
#include <regex.h>
#endif
#endif

