/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_ERRNO
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_STDLIB

#include "config.h"
#include "includes.h"
#include "readline.h"
#include "prototypes.h"

static struct BFILE input;
void mailforwarderror(char *mailbox);

int mailforward(char *file,char *to,char *hostname,char *smtpservice){
  int j=0,pid;
  int pipefd[2],n;
  char command[LINESIZE],*subject[LINESIZE];
  char *path;
  static char *arguments[3]={SENDMAIL,"-bs",NULL};

  input.fd=fstdio[0];
  input.NR=0;
  path=getenv("PATH");

  close(0);
  fstdioopen();
  if(freopen(file,"r",fstdio[0])==NULL){
    fprintf(fstdio[2],"mailforward open error\n");
    return 1;
  };
  if(feof(fstdio[0])){
    fprintf(fstdio[2],"mailforward open at eof\n");
    return 1;
  };

  if(smtpservice!=NULL){
    if((pipefd[1]=inetconnect(smtpservice,hostname))<0){
      fprintf(fstdio[2],"Connection to %s refused\n",smtpservice);
      return 1;
    };
  }else
    pipefd[1]==-1;

  if(pipefd[1]>=0){
    pipefd[0]=-1;
    pid=1;
  }else{
    if(pipe(pipefd)!=0){
      fprintf(fstdio[2],"pipe error\n");
      return -1;
    };
    pid=fork();
  };
  if(pid!=-1){
    FILE *pipef;
    int blankline=0;

    if(!pid){
      close(pipefd[1]);
      if(pipefd[0]!=0){
        close(0);
        dup2(pipefd[0],0);
      };
      fprintf(fstdio[1],"Executing " SENDMAIL " (%s) %s %s\n",
        arguments[0],arguments[1],arguments[2]);
      execv(hash(path,SENDMAIL),arguments);
      fprintf(fstdio[1],"Errno %d\n",errno);
      exit(1);
    };
    if(pipefd[0]!=-1) close(pipefd[0]);
    pipef=fdopen(pipefd[1],"w");
    fprintf(pipef,"HELO %s\n",hostname);

    for(n=0;readline(&input,n)>-1;n++){
      if(!strncmp(input.line,"From ",5)){
        char *dummy;

        if(n!=0){
          if(blankline)
            fprintf(pipef,"%c\n",'.');
          else
            fprintf(pipef,"\n%c\n",'.');
        };
        if(n!=0) fprintf(pipef,"%c\n",'.');
        fprintf(pipef,"MAIL FROM: %s\n",parseaddress(&input.line[4],&dummy));
        fprintf(pipef,"RCPT TO: %s\n",to);
        fprintf(pipef,"DATA\n");
        fprintf(pipef,"%s%s\n",XCOMMAND,C_FORWARD);
      }else if(input.line[0]=='.'){
        if(fprintf(pipef,".%s",input.line)<0){
          n=-1;
          break;
        };
      }else{
        if(fprintf(pipef,"%s",input.line)<0){
          n=-1;
          break;
        };
      };
      blankline=!strcmp(input.line,"\n");
    };

    if(n>0){
      if(blankline){
        if(fprintf(pipef,"%c\nQUIT\n",'.')<0) n=-1;
      }else
        if(fprintf(pipef,"\n%c\nQUIT\n",'.')<0) n=-1;
    }else if(!n)
      fprintf(pipef,"QUIT\n",'.');

    close(pipefd[0]);
    fclose(pipef);
    if(n<0){
      fprintf(fstdio[2],"Connection lost\n");
      if(pipefd[0]!=-1) kill(pid,SIGKILL);
      return 1;
    };
    if(pipefd[0]!=-1){
      wait(&j);
      fprintf(fstdio[2],"Mailforward Exit %d\n",j);
      return j;
    };
    return 0;
  }else{
    if(pipefd[0]!=-1) close(pipefd[0]);
    if(pipefd[0]!=-1) close(pipefd[1]);
    fprintf(fstdio[2],"fork error\n");
  };
  return -1;
}

