/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_FCNTL
#define IS_STAT
#define IS_STDIO
#define IS_STRING
#define IS_TYPES
#define IS_UNISTD

#include "config.h"
#include "includes.h"
#include "prototypes.h"


/* This routine checks if "from" matches a regulare expression either
 * in the allow or the deny file.
 */

int searchforuser(FILE *fd,char *from,char *extra){
  char *lextra;
  char line[LINESIZE],user[LINESIZE],host[LINESIZE],ex[LINESIZE];

  if(fd!=NULL){
    while(fgets(line,LINESIZE,fd)!=NULL){
      if(strlen(line)<2  || line[0]=='#') continue;
      if(index(line,'@')!=NULL){
        *index(line,'@')=' ';
        lextra=NULL;
        if(sscanf(line,"%s %s %s %[^\n]",user,host,lextra,ex)<2)  continue;
      }else{
        if(index(line,'!')==NULL)
          strcpy(host,"localhost");
        else
          strcpy(host,"");
        if(sscanf(line,"%s %s %[^\n]",user,lextra,ex)<1)  continue;
      }; 
      if(!strlen(user)) continue;
      if(usercmp(from,user,host)){
        if(extra!=NULL){
          if(lextra!=NULL) 
	    strcpy(extra,lextra);
	  else
	    extra[0]='\0';
        };
        fclose(fd);
        return 1;
      };
    };
    fclose(fd);
  }; 
  return 0;
}

