/*
 * NAME
 *   RebuildArticleIndexes.c
 * DESCRIPTION
 *   Rebuild all of skim's article indexes.
 * COPYRIGHT
 *   Skim - Off-line news reading package optimized for slow lines.
 *   Copyright (C) 1995  Rene W.J. Pijlman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * VERSION
 *   Skim version 0.6.
 */

#include <dirent.h>

#include "VarBuf.h"
#include "Skim.h"

FILE_ID("/home/rene/sys/CVS_MasterSourceRepository/skim/RebuildArticleIndexes.c,v 1.3 1995/08/15 19:33:36 rpijlman Exp" );

int main( int argc, char ** argv )
{
    FILE * ArticleIndex;
    VarBuf NewsGroup = VBCreate();
    VarBuf ArticleDirectoryName = VBCreate();
    VarBuf ArticleFileName = VBCreate();
    VarBuf ArticleNumber = VBCreate();
    VarBuf IndexFileName = VBCreate();
    struct dirent * DirectoryEntry;
    DIR * ArticleDirectory;

    if ( argc != 1 )
    {
        fprintf( stderr, "RebuildArticleIndexes\n" );
        exit( EXIT_FAILURE );
    }

    VBPrintf( ArticleDirectoryName, "%s/Articles", SkimDir() );

    ArticleDirectory = opendir( VBAsString(ArticleDirectoryName) );
    if ( ArticleDirectory == NULL )
    {
        fprintf( stderr, "Error opening directory %s\n", 
                 VBAsString(ArticleDirectoryName) );
        exit( EXIT_FAILURE );
    }

    while ( ( DirectoryEntry = readdir( ArticleDirectory ) ) != NULL )
    {
        /* Skip "." and "..", and possibly other dot files as well. */
        if ( DirectoryEntry->d_name[0] != '.' )
        {
	    char * LastDot = NULL;
	    char * p;

	    for ( p = DirectoryEntry->d_name;
		  *p != '\0';
		  p++ )
	    {
	        if ( *p == '.' )
	        {
	            LastDot = p;
	        }
	    }

	    if ( LastDot == NULL )
	    {
		fprintf( stderr, "Incorrect file name: %s\n",  
			 DirectoryEntry->d_name );
		exit( EXIT_FAILURE );
	    }

	    for ( p = DirectoryEntry->d_name; p < LastDot; p++ )
	    {
		VBAppendCharacter( NewsGroup, *p );
	    }

	    for ( p = LastDot + 1; *p != '\0'; p++ )
	    {
		VBAppendCharacter( ArticleNumber, *p );
	    }

	    VBPrintf( IndexFileName,
		      "%s/Indexes/Articles/%V",
		      SkimDir(), NewsGroup );
	    VBPrintf( ArticleFileName, "%V/%s",
		      ArticleDirectoryName, DirectoryEntry->d_name );

	    ArticleIndex = fopen( VBAsString(IndexFileName), "a" );
	    if ( ArticleIndex == NULL )
	    {
		fprintf( stderr, "Cannot open index file %s\n",
			 VBAsString( IndexFileName ) );
		exit( EXIT_FAILURE );
	    }

	    AddArticleToIndex( ArticleFileName, ArticleNumber, ArticleIndex );

	    if ( fclose( ArticleIndex ) == EOF )
	    {
		fprintf( stderr, "Error closing %s\n", VBAsString(IndexFileName) );
		exit( EXIT_FAILURE );
	    }

	    VBReset( NewsGroup );
	    VBReset( ArticleFileName );
	    VBReset( ArticleNumber );
	    VBReset( IndexFileName );
	}
    }

    (void)closedir( ArticleDirectory );

    VBDestroy( NewsGroup );
    VBDestroy( ArticleDirectoryName );
    VBDestroy( ArticleFileName );
    VBDestroy( ArticleNumber );
    VBDestroy( IndexFileName );

    return EXIT_SUCCESS;
}
