/*
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
static char copyright[] = "Copyright (c) 1990 Regents of the University of California.\nAll rights reserved.\n";
static char SccsId[] = "@(#)@(#)popper.c	2.1  2.1 3/18/91";
#endif

#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <setjmp.h>
#include <ctype.h>

#ifdef POPSCO
#include <sys/security.h>
#include <sys/audit.h>
#include <prot.h>
#endif

#include "popper.h"

extern  state_table *   pop_get_command();
int hangup = FALSE ;
int catchSIGHUP();

int	pop_timeout = POP_TIMEOUT;

int	simple_from = FALSE;

/* 
 *  popper: Handle a Post Office Protocol version 3 session
 */
main (argc, argv)
int         argc;
char    **  argv;
{
    POP                 p;
    state_table     *   s;
    char                message[MAXLINELEN];
    char            *   tgets();

    umask(0077);    /* Set umask to remove privilages from group and world */
		    /* Better security */

#ifdef POPSCO
    (void) set_auth_parameters(argc, argv);
#endif

    (void) signal(SIGHUP,(void *)catchSIGHUP);
    (void) signal(SIGPIPE,(void *)catchSIGHUP);

    /*  Start things rolling */
    if (pop_init(&p,argc,argv) != POP_SUCCESS)
	exit(-1);

    /*  Tell the user that we are listenting */
    pop_msg(&p,POP_SUCCESS,
        "UCB Pop server (version %s) at %s starting.",VERSION,p.myhost);

    /*  State loop.  The POP server is always in a particular state in 
        which a specific suite of commands can be executed.  The following 
        loop reads a line from the client, gets the command, and processes 
        it in the current context (if allowed) or rejects it.  This continues 
        until the client quits or an error occurs. */

    for (p.CurrentState=auth1;p.CurrentState!=halt&&p.CurrentState!=error;) {
        if (hangup) {
            pop_msg(&p,POP_FAILURE,"POP hangup",p.myhost);
            if (p.CurrentState > auth2 && !pop_updt(&p))
                pop_msg(&p,POP_FAILURE,"POP mailbox update failed.",p.myhost);
            p.CurrentState = error;
        } else if (tgets(message,MAXLINELEN,p.input,pop_timeout) == NULL) {
            pop_msg(&p,POP_FAILURE,"POP timeout",p.myhost);
            if (p.CurrentState > auth2 && !pop_updt(&p))
                pop_msg(&p,POP_FAILURE,"POP mailbox update failed!",p.myhost);
            p.CurrentState = error;
        } else if ((s = pop_get_command(&p,message)) != NULL) {
            if (s->function != NULL) {
                p.CurrentState = s->result[(*s->function)(&p)];
            } else {
                p.CurrentState = s->success_state;
                pop_msg(&p,POP_SUCCESS,NULL);
            }
        }
    }

    /*  Say goodbye to the client */
    pop_msg(&p,POP_SUCCESS,"Pop server at %s signing off.",p.myhost);

    /*  Log the end of activity */
    pop_log(&p,POP_PRIORITY,
        "(v%s) Ending request from \"%s\" at (%s) %s\n",
					VERSION,p.user,p.client,p.ipaddr);

    /*  Stop logging */
    closelog();

    return(0);
}

jmp_buf env;

/*
 * fgets, but with a timeout
 */
char *tgets(str,size,fp,timeout)
char *str;
int size;
FILE *fp;
int timeout;
{
  int ring();
  (void) signal(SIGALRM, (void *)ring);
  alarm(timeout);
  if (setjmp(env))
    str = NULL;
  else
    str = fgets(str,size,fp);
  alarm(0);
  signal(SIGALRM,SIG_DFL);
  return(str);
}

int ring()
{
  longjmp(env,1);
}
  

#ifdef STRNCASECMP
/*
 *  Perform a case-insensitive string comparision
 */
strncasecmp(str1,str2,len)
register char   *   str1;
register char   *   str2;
register int        len;
{
    register int    i;
    char            a,
                    b;

    for (i=len-1;i>=0;i--){
        a = str1[i];
        b = str2[i];
        if (isupper(a)) a = tolower(str1[i]);
        if (isupper(b)) b = tolower(str2[i]);
        if (a > b) return (1);
        if (a < b) return(-1);
    }
    return(0);
}
#endif

int catchSIGHUP()
{
    extern int hangup ;

    hangup = TRUE ;

    /* This should not be a problem on BSD systems */
    signal(SIGHUP,  (void *)catchSIGHUP);
    signal(SIGPIPE,  (void *)catchSIGHUP);
}

/*
 * $Author: mark $ $Date: 1994/11/01 01:43:15 $
 * $Header: /local/src/popper/npopper/qpopper2.1.3/RCS/popper.c,v 1.8 1994/11/01 01:43:15 mark Exp $
 * $Revision: 1.8 $
 */

#ifdef POPSCO
/*
 * Ftruncate() for non-BSD systems.
 *
 * This module gives the basic functionality for ftruncate() which
 * truncates the given file descriptor to the given length.
 * ftruncate() is a Berkeley system call, but does not exist in any
 * form on many other versions of UNIX such as SysV. Note that Xenix
 * has chsize() which changes the size of a given file descriptor,
 * so that is used if M_XENIX is defined.
 *
 * Since there is not a known way to support this under generic SysV,
 * there is no code generated for those systems.
 *
 * SPECIAL NOTE: On Xenix, using this call in the BSD library
 * will REQUIRE the use of -lx for the extended library since chsize()
 * is not in the standard C library.
 *
 * By Marc Frajola, 3/27/87
 */

#include <fcntl.h>

ftruncate(fd,length)
    int fd;			/* File descriptor to truncate */
    off_t length;		/* Length to truncate file to */
{
    int status;			/* Status returned from truncate proc */

    status = chsize(fd,length);
/*
    status = -1;
    NON-XENIX SYSTEMS CURRENTLY NOT SUPPORTED
*/

    return(status);
}
#endif

