/*========================================================================*
 * TITLE:	Motif help system
 * MODULE:	mhelp.c
 * BY:		Ross C Linder (c) 1995 
 *
 * Note: This software is free, you may use it for any purpose you see
 *       commercial or otherwise. Note for commercial purposes make sure
 *       that you comply with NCSA limitations. See xpmread.c and look
 *       in your libhtmlw documentation.
 *
 * Assumtions: That toplevel and disp are global !
 *========================================================================*/

static char id[] =
"@(#)mhelp.c	$Revision: 1.1 $	$Date: 1995/05/19 12:29:52 $\000"
"@(#)Copyright (c) 1995 Ross C Linder";


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <Xm/MessageB.h>
#include <X11/xpm.h>
#include <libhtmlw/HTML.h>

#define MAX_IMG		100		/* Max no of images in a thread */

static void	ok_cb (void);
ImageInfo	*process_image (Widget w, char *name, int noload);
unsigned char	*ReadGIF ();

Widget		mhelp_view = NULL;	/* The html widget */
static Widget	help_dialog;		/* The dialog for the html wid */
static char	*data_buff = NULL;	/* Where we put the help data */
static char	last_href[256];		/* Only turkeys will out do these */
static char	last_text[256];		/* values, and as such deserve to */
static char	root_path[128];		/* get eaten for thanksgiving ! */
extern Widget	toplevel;		/* Copies to prevent confusion */
extern Display	*disp;


/*========================================================================*
 * ANCHOR_CB -- Load up and/or display new Href 
 *========================================================================*/

static void anchor_cb (Widget w, XtPointer cd, WbAnchorCallbackData *cbd)
{
FILE	*fp;
static char	ebuf[256];
struct stat	stb;
char		*hash, *tok;
char		tbuf[256];

#ifdef DEBUG
    printf ("Href: \"%s\" \"%s\"\n", cbd->text, cbd->href);
#endif

    /*==== This might look stupid, but strtok modifies the string ====*/
    /*==== Causing memory violations as the sting is in the code  ====*/
    /*==== Beware: this was a tricky bug to find, very random !   ====*/

    strcpy (tbuf, cbd->href);		/* Safe for strtok */
			
    hash = strchr (cbd->href, '#');
    tok = strtok (tbuf, "#");

    if (tok == NULL)
	tok = cbd->href;

    if (strcmp (tok, last_href)) {
	strcpy (ebuf, root_path);
	strcat (ebuf, tok);
	if ((fp = fopen (ebuf, "r")) != NULL) {
	    stat (cbd->href, &stb);
	    if (data_buff != NULL)
		free (data_buff);

	    if ((data_buff = malloc (stb.st_size+1)) == NULL) {
		sprintf (ebuf, "Fatal Error: Not enough memory to display"
			" the \"%s\" help thread", tok);
		HTMLSetText (w, ebuf, NULL, NULL, 0, NULL, 0);
		fclose (fp);
		return;
		}
	    
	    fread (data_buff, stb.st_size, 1, fp);
	    data_buff[stb.st_size] = 0;
	    strcpy (last_href, cbd->href);
	    strcpy (last_text, cbd->text);
	    fclose (fp);
	    }
	else {
	    sprintf (ebuf, "Help document %s not found<P>"
	     "<A HREF=\"%s\">Return</A>", cbd->href, last_href);
#ifdef DEBUG
	    printf ("Returning to \"%s\"\n", ebuf);
#endif
	    HTMLSetText (w, ebuf, NULL, NULL, 0, NULL, 0);
	    return;
	    }

	HTMLSetText (w, data_buff, NULL, NULL, 0, NULL, 0);
	}
    else if (hash == NULL)
	HTMLSetText (w, data_buff, NULL, NULL, 0, NULL, 0);

    if (hash != NULL) {
#ifdef DEBUG
	printf ("Goining to ref \"%s\"\n", &hash[1]);
#endif
	HTMLGotoId (w, HTMLAnchorToId (w, &hash[1]));
	}
}


/*========================================================================*
 * INIT_HELP -- Create the help diaglog, and prime it, but don't
 *              manage it yet.
 *========================================================================*/

int init_help (Widget parent, char *tit, char *hname)
{
Arg		args[9];
Widget		button;
XmString	xms, xms1;
Widget		txw, tw;
char		*txt;
FILE		*fp;
char		**hrefs;
int		a;
struct stat	stb;
char		ebuf[256];

    if (mhelp_view != NULL)
	return -1;

    strcpy (root_path, hname);
    if ((txt = strrchr (root_path, '/')) == NULL)
	strcpy (root_path, "./");
    else
	txt[1] = 0;

    if ((txt = strrchr (hname, '/')) == NULL)
	txt = hname;
    else
	txt++;

    if ((fp = fopen (hname, "r")) == NULL)
	return -1;

    stat (hname, &stb);
    if ((data_buff = malloc (stb.st_size+1)) == NULL) {
	sprintf (ebuf, "Fatal Error: Not enough memory to display"
			" the \"%s\" help thread", hname);
	data_buff = strdup (ebuf);
	}
    else {
	strcpy (last_href, txt);
	fread (data_buff, stb.st_size, 1, fp);
	data_buff[stb.st_size] = 0;
	}

    fclose (fp);

    xms = XmStringCreateLtoR (tit, XmFONTLIST_DEFAULT_TAG);
    xms1 = XmStringCreateSimple ("DISMISS");
    XtSetArg (args[0], XmNokLabelString, xms1);
    XtSetArg (args[1], XmNdialogTitle, xms);
    help_dialog = XmCreateMessageDialog (parent, "mhelp", args, 2);

    button = XmMessageBoxGetChild (help_dialog, XmDIALOG_CANCEL_BUTTON);
    XtUnmanageChild (button);
    button = XmMessageBoxGetChild (help_dialog, XmDIALOG_HELP_BUTTON);
    XtUnmanageChild (button);

    tw = XmMessageBoxGetChild (help_dialog, XmDIALOG_MESSAGE_LABEL);
    txw = XtParent (tw);
    XtDestroyWidget (tw);

    XtSetArg (args[0], XmNwidth ,550);
    XtSetArg (args[1], XmNheight ,300);
    XtSetArg (args[2], WbNdelayImageLoads, False);
    XtSetArg (args[3], WbNfancySelections, True);
    XtSetArg (args[4], XmNresizePolicy, XmRESIZE_ANY);
    XtSetArg (args[5], WbNresolveImageFunction, process_image);
    
    tw = XtVaCreateManagedWidget ("texthtml", htmlWidgetClass, txw, 0);
    mhelp_view = tw;

    XtSetValues (tw, args, 6);

    XtAddCallback (tw, WbNanchorCallback, (XtCallbackProc) anchor_cb, 0);
    
    XmStringFree (xms);
    XmStringFree (xms1);

    XtAddCallback (help_dialog, XmNokCallback, (XtCallbackProc) ok_cb, 0);

    HTMLSetText (tw, data_buff, NULL, NULL, 0, NULL, 0);
}

/*========================================================================*
 * OK_CB -- Exit on OK pressed
 *========================================================================*/

static void ok_cb (void)
{
    XtUnmanageChild (mhelp_view);
    XtUnmanageChild (help_dialog);
}


/*========================================================================*
 * HELP_GOTO_REF -- for positioning to a particular location
 *========================================================================*/

help_goto_ref (char *href, char *text)
{
WbAnchorCallbackData	cbd;

    cbd.href = href;		/* This can be used like this only */
    cbd.text = text;		/* because I wrote anchor_cb ;) */

    if (href != NULL || text != NULL)
	anchor_cb (mhelp_view, NULL, &cbd);

    XtManageChild (mhelp_view);
    XtManageChild (help_dialog);
}


/*========================================================================*
 * PROCESS_IMAGE -- Get image info from cache if there, or load it into
 *                  the cache and return info.
 *
 * Handles: XPM3, GIF, 
 *========================================================================*/

static struct	{
	char		*name;
	ImageInfo	*img;
	} img_cache[MAX_IMG];

ImageInfo *process_image (Widget w, char *name, int noload)
{
unsigned char	*data;
int		bg;
int		width, height;
ImageInfo	*img_data;
XColor		colrs[256], tcolor;
FILE		*fp;
int		a, b, cn, ncols;
char		fname[256];
XpmAttributes	attrs;
XImage		*idata;
Pixel		bg_pix;

    for (cn = 0; cn < MAX_IMG; cn++) {
	if (img_cache[cn].name == NULL)
	    break;

	if (strcmp (name, img_cache[cn].name) == 0)
	    return img_cache[cn].img;
	}

    if (cn == MAX_IMG) {
	printf ("Fatal img cache full\n");
	exit (1);
	}

    img_cache[cn].name = strdup (name);

    strcpy (fname, root_path);
    strcat (fname, name);
    if ((fp = fopen (fname, "r")) == NULL)
	return NULL;

    img_data = (ImageInfo *)calloc(1, sizeof(ImageInfo));
    attrs.valuemask = XpmUndefPixel | XpmReturnPixels | XpmReturnColorTable;

    if (XpmReadFileToImage (disp, fname, &idata, NULL, &attrs) == XpmSuccess) {
	img_data->width = attrs.width;
	img_data->height = attrs.height;
	img_data->image_data = calloc (1, attrs.width * attrs.height);
	img_data->internal = 0;
	img_data->num_colors = attrs.ncolors;

	img_data->reds = malloc (attrs.ncolors * sizeof (int));
	img_data->blues = malloc (attrs.ncolors * sizeof (int));
	img_data->greens = malloc (attrs.ncolors * sizeof (int));

	for (a = 0; a < attrs.ncolors; a++) {
	    if (strcmp (attrs.colorTable[a].c_color, "None") == 0) {
		XtVaGetValues (mhelp_view, XtNbackground, &bg_pix, NULL);
		tcolor.pixel = bg_pix;

		XQueryColor (disp, DefaultColormap ((disp),
			  DefaultScreen (disp)), &tcolor);
		}
	    else {
		XParseColor (disp, DefaultColormap (disp,
		DefaultScreen (disp)), attrs.colorTable[a].c_color, &tcolor);
		}

	    img_data->reds[a] = tcolor.red;
	    img_data->greens[a] = tcolor.green;
	    img_data->blues[a] = tcolor.blue;
	    }
	
	for (a = 0; a < attrs.width * attrs.height; a++) {
	    for (b = 0; b < attrs.npixels; b++)
		if (idata->data[a] == attrs.pixels[b])
		    break;
	    img_data->image_data[a] = b;
	    }

	XpmFreeAttributes (&attrs);
	XpmFreeAttributes (&idata);
	}
    else {
	if ((data = ReadGIF (fp, &width, &height, colrs, &bg, &ncols))
							     == NULL) {
	    fclose (fp);
	    free (img_data);
	    return NULL;
	    }

	img_data->num_colors = ncols;
	img_data->reds = malloc (ncols * sizeof (int));
	img_data->blues = malloc (ncols * sizeof (int));
	img_data->greens = malloc (ncols * sizeof (int));

	for (a = 0; a < ncols; a++) {
	    img_data->reds[a] = colrs[a].red;
	    img_data->greens[a] = colrs[a].green;
	    img_data->blues[a] = colrs[a].blue;
	    }

	img_data->width = width;
	img_data->height = height;
	img_data->image_data = data;
	}
 
    img_cache[cn].img = img_data;

    return img_data;
}
