/*========================================================================*
 * TITLE:	Qwik Mail Reader for Unix/Linux
 * MODULE:	util.c -- misc X utils
 * BY:		Ross C LINDER	(c) 1994 All rights reserved
 *
 * X11-QMR is Copyright (c) 1994 of Ross C Linder. X11-QMR is not public
 * domain. Permission is granted to use and distribute X11-QMR freely.
 * 
 * The only restriction is that you do not attempt to prevent others from
 *  having free access to the source.
 *========================================================================*/


#include <stdlib.h>
#include <stdarg.h>
#include <sys/errno.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include "util.h"


static char id[]=

"@(#)util.c	$Revision: 1.4 $	$Date: 1995/05/19 12:28:50 $";

/*========================================================================*/

extern Widget  		toplevel;
extern Display 		*disp;
extern XtAppContext	app_context;

static void	info_but_cb ();
static void	(*info_ucall)();
static Widget	infoW = NULL;

static void	query_but_cb ();
static void	(*query_ucall)();
static Widget	queryW = NULL;

static void	error_but_cb ();
static void	(*error_ucall)();
static Widget	errorW = NULL;

static void	work_but_cb ();
static void	(*work_ucall)();
static Widget	workW = NULL;

static void	warn_but_cb ();
static void	(*warn_ucall)();
static Widget	warnW = NULL;


/*========================================================================*
 * TREE_WIDGET -- Get the Widget id from a tree of widget names
 *========================================================================*/

Widget tree_widget (Widget parent, ...)
{
Widget	twid = parent;
va_list	ap;
char	*arg;

    va_start (ap, parent);

    for (;;) {
	arg = va_arg (ap, char *);
	if (*arg == 0)
	    break;			/* End of list */

	twid = XtNameToWidget (twid, arg);
	if (twid == NULL)
	    break;
        }

    return twid;
}


/*======================================================================* 
 * FORCE_UPDATE -- make window contents visible before returning.
 *=====================================================================*/

void force_update (Widget w)
{
Widget                  dshell, tshell;
Window                  dwin, twin;
XWindowAttributes       xwa;
XEvent                  event;

    for (dshell = w; !XtIsShell (dshell); dshell = XtParent (dshell));

    for (tshell = dshell; !XtIsTopLevelShell (tshell);
                tshell = XtParent (tshell));

    if (XtIsRealized(dshell) && XtIsRealized (tshell)) {
        dwin = XtWindow (dshell);
        twin = XtWindow (tshell);

        while (XGetWindowAttributes (disp, dwin, &xwa) && 
                                xwa.map_state != IsViewable) {
            if (XGetWindowAttributes (disp, twin, &xwa) &&
                                xwa.map_state != IsViewable) 
                break;

            XtAppNextEvent (app_context, &event);
            XtDispatchEvent (&event);
            }
        }

    XmUpdateDisplay (tshell);
}

/*========================================================================*
 * UPDATE_APP -- Flush X events for an application
 *========================================================================*/

void update_app (XtAppContext apc)
{
XEvent  ev;

    while (XtIMXEvent & XtAppPending (apc)) {
	XtAppNextEvent (apc, &ev);
	XtDispatchEvent (&ev);
	}
}


/*========================================================================*
 * INFO_DIALOG -- Create/Manage and info dialog
 *========================================================================*/

Widget info_dialog (char *text, char *but1, char *but2, char *but3,
							void (*call))
{
Arg		args[5];
XmString	xst;
int		a;
Widget		twid;

    if (infoW == NULL) {
        a = 0;
        xst = XmStringCreateLtoR (" ", XmFONTLIST_DEFAULT_TAG);
        XtSetArg (args[a], XmNdialogTitle, xst); a++;
        infoW = XmCreateInformationDialog (toplevel, "dialog", args, a);
        XtManageChild (infoW);
        XtAddCallback (infoW, XmNhelpCallback, (XtCallbackProc)info_but_cb,
			(XtPointer) 2);
        XtAddCallback (infoW, XmNokCallback, (XtCallbackProc)info_but_cb,
			(XtPointer) 0);
        XtAddCallback (infoW, XmNcancelCallback, (XtCallbackProc)info_but_cb,
			(XtPointer) 1);
        XmStringFree (xst);
        }

    info_ucall = call;

    a = 0;
    xst = XmStringCreateLtoR (text, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNmessageString, xst); a++;
    XtSetValues (infoW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but1, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNokLabelString, xst); a++;
    XtSetValues (infoW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but2, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNcancelLabelString, xst); a++;
    XtSetValues (infoW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but3, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNhelpLabelString, xst); a++;
    XtSetValues (infoW, args, a);
    XmStringFree (xst);

    twid = XmMessageBoxGetChild (infoW, XmDIALOG_OK_BUTTON);
    if (but1[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (infoW, XmDIALOG_CANCEL_BUTTON);
    if (but2[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (infoW, XmDIALOG_HELP_BUTTON);
    if (but3[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    XtManageChild (infoW);
    twid = XmMessageBoxGetChild (infoW, XmDIALOG_MESSAGE_LABEL);
    force_update (twid);

    return infoW;
}

/*========================================================================*
 * INFO_BUT_CB -- Callback for buttons on info dialog
 *========================================================================*/

static void info_but_cb (w, b)
Widget  w;
{
    XtUnmanageChild (infoW);
    if (info_ucall)
        info_ucall (b+1);
}


/*========================================================================*
 * QUERY_DIALOG -- Create/Manage and query dialog
 *========================================================================*/

Widget query_dialog (char *text, char *but1, char *but2, char *but3,
							void (*call))
{
Arg		args[5];
XmString	xst;
int		a;
Widget		twid;

    if (queryW == NULL) {
        a = 0;
        xst = XmStringCreateLtoR (" ", XmFONTLIST_DEFAULT_TAG);
        XtSetArg (args[a], XmNdialogTitle, xst); a++;
        queryW = XmCreateQuestionDialog (toplevel, "dialog", args, a);
        XtManageChild (queryW);
        XtAddCallback (queryW, XmNhelpCallback, (XtCallbackProc)query_but_cb,
			(XtPointer) 2);
        XtAddCallback (queryW, XmNokCallback, (XtCallbackProc)query_but_cb,
			(XtPointer) 0);
        XtAddCallback (queryW, XmNcancelCallback, (XtCallbackProc)query_but_cb,
			(XtPointer) 1);
        XmStringFree (xst);
        }

    query_ucall = call;

    a = 0;
    xst = XmStringCreateLtoR (text, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNmessageString, xst); a++;
    XtSetValues (queryW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but1, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNokLabelString, xst); a++;
    XtSetValues (queryW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but2, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNcancelLabelString, xst); a++;
    XtSetValues (queryW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but3, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNhelpLabelString, xst); a++;
    XtSetValues (queryW, args, a);
    XmStringFree (xst);

    twid = XmMessageBoxGetChild (queryW, XmDIALOG_OK_BUTTON);
    if (but1[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (queryW, XmDIALOG_CANCEL_BUTTON);
    if (but2[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (queryW, XmDIALOG_HELP_BUTTON);
    if (but3[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    XtManageChild (queryW);
    twid = XmMessageBoxGetChild (queryW, XmDIALOG_MESSAGE_LABEL);
    force_update (twid);

    return queryW;
}

/*========================================================================*
 * QUERY_BUT_CB -- Callback for buttons on query dialog
 *========================================================================*/

static void query_but_cb (w, b)
Widget  w;
{
    XtUnmanageChild (queryW);
    if (query_ucall)
        query_ucall (b+1);
}


/*========================================================================*
 * ERROR_DIALOG -- Create/Manage and error dialog
 *========================================================================*/

Widget error_dialog (char *text, char *but1, char *but2, char *but3,
							void (*call))
{
Arg		args[5];
XmString	xst;
int		a;
Widget		twid;

    if (errorW == NULL) {
        a = 0;
        xst = XmStringCreateLtoR (" ", XmFONTLIST_DEFAULT_TAG);
        XtSetArg (args[a], XmNdialogTitle, xst); a++;
        errorW = XmCreateErrorDialog (toplevel, "dialog", args, a);
        XtManageChild (errorW);
        XtAddCallback (errorW, XmNhelpCallback, (XtCallbackProc)error_but_cb,
			(XtPointer) 2);
        XtAddCallback (errorW, XmNokCallback, (XtCallbackProc)error_but_cb,
			(XtPointer)  0);
        XtAddCallback (errorW, XmNcancelCallback, (XtCallbackProc)error_but_cb,
			(XtPointer)  1);
        XmStringFree (xst);
        }

    error_ucall = call;

    a = 0;
    xst = XmStringCreateLtoR (text, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNmessageString, xst); a++;
    XtSetValues (errorW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but1, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNokLabelString, xst); a++;
    XtSetValues (errorW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but2, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNcancelLabelString, xst); a++;
    XtSetValues (errorW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but3, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNhelpLabelString, xst); a++;
    XtSetValues (errorW, args, a);
    XmStringFree (xst);

    twid = XmMessageBoxGetChild (errorW, XmDIALOG_OK_BUTTON);
    if (but1[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (errorW, XmDIALOG_CANCEL_BUTTON);
    if (but2[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (errorW, XmDIALOG_HELP_BUTTON);
    if (but3[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    XtManageChild (errorW);
    twid = XmMessageBoxGetChild (errorW, XmDIALOG_MESSAGE_LABEL);
    force_update (twid);

    return errorW;
}

/*========================================================================*
 * ERROR_BUT_CB -- Callback for buttons on error dialog
 *========================================================================*/

static void error_but_cb (w, b)
Widget  w;
{
    XtUnmanageChild (errorW);
    if (error_ucall)
        error_ucall (b+1);
}


/*========================================================================*
 * WORKING_DIALOG -- Create/Manage a working dialog
 *========================================================================*/

Widget working_dialog (char *text, char *but1, char *but2, char *but3,
							void (*call))
{
Arg		args[5];
XmString	xst;
int		a;
Widget		twid;

    if (workW == NULL) {
        a = 0;
        xst = XmStringCreateLtoR (" ", XmFONTLIST_DEFAULT_TAG);
        XtSetArg (args[a], XmNdialogTitle, xst); a++;
        workW = XmCreateWorkingDialog (toplevel, "dialog", args, a);
        XtManageChild (workW);
        XtAddCallback (workW, XmNhelpCallback, (XtCallbackProc)work_but_cb,
			(XtPointer)  2);
        XtAddCallback (workW, XmNokCallback, (XtCallbackProc)work_but_cb,
			(XtPointer)  0);
        XtAddCallback (workW, XmNcancelCallback, (XtCallbackProc)work_but_cb,
			(XtPointer)  1);
        XmStringFree (xst);
        }

    work_ucall = call;

    a = 0;
    xst = XmStringCreateLtoR (text, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNmessageString, xst); a++;
    XtSetValues (workW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but1, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNokLabelString, xst); a++;
    XtSetValues (workW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but2, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNcancelLabelString, xst); a++;
    XtSetValues (workW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but3, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNhelpLabelString, xst); a++;
    XtSetValues (workW, args, a);
    XmStringFree (xst);

    twid = XmMessageBoxGetChild (workW, XmDIALOG_OK_BUTTON);
    if (but1[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (workW, XmDIALOG_CANCEL_BUTTON);
    if (but2[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (workW, XmDIALOG_HELP_BUTTON);
    if (but3[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    XtManageChild (workW);
    twid = XmMessageBoxGetChild (workW, XmDIALOG_MESSAGE_LABEL);
    force_update (twid);

    return workW;
}

/*========================================================================*
 * WORK_BUT_CB -- Callback for buttons on work dialog
 *========================================================================*/

static void work_but_cb (w, b)
Widget  w;
{
    XtUnmanageChild (workW);
    if (work_ucall)
        work_ucall (b+1);
}


/*========================================================================*
 * WARN_DIALOG -- Create/Manage a warning dialog
 *========================================================================*/

Widget warn_dialog (char *text, char *but1, char *but2, char *but3,
							void (*call))
{
Arg		args[5];
XmString	xst;
int		a;
Widget		twid;

    if (warnW == NULL) {
        a = 0;
        xst = XmStringCreateLtoR (" ", XmFONTLIST_DEFAULT_TAG);
        XtSetArg (args[a], XmNdialogTitle, xst); a++;
        warnW = XmCreateWarningDialog (toplevel, "dialog", args, a);
        XtManageChild (warnW);
        XtAddCallback (warnW, XmNhelpCallback, (XtCallbackProc)warn_but_cb,
			(XtPointer)  2);
        XtAddCallback (warnW, XmNokCallback, (XtCallbackProc)warn_but_cb,
			(XtPointer)  0);
        XtAddCallback (warnW, XmNcancelCallback, (XtCallbackProc)warn_but_cb,
			(XtPointer)  1);
        XmStringFree (xst);
        }

    warn_ucall = call;

    a = 0;
    xst = XmStringCreateLtoR (text, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNmessageString, xst); a++;
    XtSetValues (warnW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but1, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNokLabelString, xst); a++;
    XtSetValues (warnW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but2, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNcancelLabelString, xst); a++;
    XtSetValues (warnW, args, a);
    XmStringFree (xst);

    a = 0;
    xst = XmStringCreateLtoR (but3, XmFONTLIST_DEFAULT_TAG);
    XtSetArg (args[a], XmNhelpLabelString, xst); a++;
    XtSetValues (warnW, args, a);
    XmStringFree (xst);

    twid = XmMessageBoxGetChild (warnW, XmDIALOG_OK_BUTTON);
    if (but1[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (warnW, XmDIALOG_CANCEL_BUTTON);
    if (but2[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    twid = XmMessageBoxGetChild (warnW, XmDIALOG_HELP_BUTTON);
    if (but3[0] == 0)
        XtUnmanageChild (twid);
    else
        XtManageChild (twid);

    XtManageChild (warnW);
    twid = XmMessageBoxGetChild (warnW, XmDIALOG_MESSAGE_LABEL);
    force_update (twid);

    return warnW;
}

/*========================================================================*
 * WARN_BUT_CB -- Callback for buttons on warn dialog
 *========================================================================*/

static void warn_but_cb (w, b)
Widget  w;
{
    XtUnmanageChild (warnW);
    if (warn_ucall)
        warn_ucall (b+1);
}

/*========================================================================*
 * XMSSTR -- Converts an XmString to char*
 *========================================================================*/

char *xmsstr (XmString xms)
{
int                     a;
char                    *str;
Boolean                 sep;
XmStringDirection       dir;
XmStringCharSet         cset;
XmStringContext         ctext;

    XmStringInitContext (&ctext, xms);
    XmStringGetNextSegment (ctext, &str, &cset, &dir, &sep);

    XmStringFreeContext (ctext);

    for (a = strlen (str) - 1; a > 0; a--)
        if (!isspace (str[a]))
            break;
        else
            str[a] = 0;

    return str;
}

/*========================================================================*
 * XMCOMBOBOXDELETEALLITEMS -- Delete all the text from the combobox
 *			       Darn OSF for omitting this function
 *========================================================================*/

void XmComboBoxDeleteAllItems (Widget w)
{
Widget	twid;

    twid = XtNameToWidget (w, "*List");
    XmListDeleteAllItems (twid);
    XmComboBoxUpdate (w);
}

/*========================================================================*
 * XMCOMBOBOXADDITEM -- Add an item to the combobox list
 *			Darn OSF for omitting this function
 *========================================================================*/

void XmComboBoxAddItem (Widget w, XmString xms, int pos)
{
Widget	twid;

    twid = XtNameToWidget (w, "*List");
    XmListAddItem (twid, xms, pos);
    XmComboBoxUpdate (w);
}


/*========================================================================*
 * XMCOMBOBOXSELECTPOS -- Set the Select possition in the combobox
 *			  Darn OSF for omitting this function
 *========================================================================*/

void XmComboBoxSelectPos (Widget w, int pos, Boolean notify)
{
Widget	twid;

    twid = XtNameToWidget (w, "*List");
    XmListSelectPos (twid, pos, notify);
    XmComboBoxUpdate (w);
}


/*========================================================================*
 * XMCOMBOBOXGETSTRING -- Get the string from the combobox textfield
 *			  Darn OSF for omitting this function
 *========================================================================*/

char * XmComboBoxGetString (Widget w)
{
Widget	twid;

    twid = XtNameToWidget (w, "*Text");
    return XmTextFieldGetString (twid);
}


/*========================================================================*
 * $Log: util.c,v $
 * Revision 1.4  1995/05/19  12:28:50  ross
 * Added ComboBox utilities to make life a little easier.
 *
 * Revision 1.3  1994/09/29  13:13:12  ross
 * changed the prototypes, and castings to remove warnings.
 *
 * Revision 1.2  1994/09/01  08:55:43  ross
 * Added XtIMXEvent mask to update_app () to stop blocking on unwanted
 * events. No longer need to move the mouse to get going.
 *
 * Revision 1.1  1994/07/24  17:49:36  ross
 * Initial revision
 *
 *========================================================================*/
