//	AGL(C)	1994
//	$Id: a_mua.g,v 3.11 1994/10/12 11:03:34 agl Exp agl $
//	My own Mail User Agent
//
#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include "mmap.i"
#include "a_mua.h"

static	char	inbox[256],boxn1[256],boxn2[256];
static	int	newmailflag=0;int	restricted=0, admin=0, auth=0;

class	FolderMover	{
public:
	void				mvspooltombox(char *inbox);	
	FolderMover(char *inbox)	{	mvspooltombox(inbox);	}
};
class	FolderBrowser	{
	Rfc822Msg	*first,*last;
	uint		n_msg;
public:	void	rewind()		{	last=first; n_msg=1;	}
	int	seek(int);
public:
	int	listsummary();
	int	listmessage(),	savemessage(char *,char *fmode, int),
				savemessage(int, FILE *fp=stdout);
	int	updatefolder(), savefolder();
	void	remove(),	undelete(),	markallread();
	uint	numread();
#define get_(field) \
	void	get_##field(char *_) {	last->get_##field(_); }
	get_(to)
	get_(cc)
	get_(from)
	get_(subject)
	get_(reply_to)
	get_(message_id)
	get_(exactsubject)
	FolderBrowser(	Rfc822Msg *_)	{	first=_; rewind();	}
};
class	Folder	{
	caddr_t	folder;
	Rfc822Msg	dummy; int id;
public:
	FolderBrowser	index,browse;
	int	open(char *name);
	int	close();
	Folder() : index(&dummy),browse(&dummy)	{	folder=0; id=-2; }
};
Folder	received;
HomeDir::HomeDir()	{ homedir=getenv("HOME"); }
HomeDir::operator char *() {
	if(homedir==0) a_fatal(grc.get(1,16),1019);
	return	homedir;
}
HomeDir	homedir;
static	int	checkfornewmail()
{
	strcpy(	inbox, homedir);
	strcat( inbox, grc.get(0,1)); 

	newmailflag=0;	FolderMover	foldermover(inbox);
	if(newmailflag)	a_print(grc.get(2,1));
	return	newmailflag;
}

uint	scr_cols=80, cur_msg=1, num_msgs=0;

/*int	copyfile(int dst_fd, int src_fd) {
const	TBSIZE=4096;
	char	transbuf[TBSIZE];	size_t	nbytes;
	for(;;)
	{
		if((nbytes=read(src_fd,transbuf,TBSIZE))==-1)
			a_fatal(grc.get(1,1),1005);
		if(nbytes==0) break;
		if(write(dst_fd,transbuf,nbytes)!=nbytes)
			a_fatal(grc.get(1,2),1007);
	}
}*/
int	appendfile(FILE *dest, FILE *src, int lock=1) {
	if(lock) {
// Only POSIX file locking style supported
	struct flock locktype;
	locktype.l_type  =F_WRLCK;
	locktype.l_whence=SEEK_SET;
	locktype.l_start =0;
	locktype.l_len   =0;
	if(fcntl(fileno(src), F_SETLKW, &locktype)==-1) {
		a_print(grc.get(1,0)); printf("ERRNO %d",errno); }
	}
	for(int ch;;)
		if((ch=fgetc(src))!=EOF) { if(fputc(ch,dest)==EOF) return 0;
			newmailflag=1; }
		else return 1;
}
//
//	should move user's mail from mail_spool_dir to user_incoming_mbox
//
char	*logname;
void	FolderMover::mvspooltombox(char *inbox)	{
	char	spoolmbox_name[512],*_mailbox;
	if((_mailbox=getenv("MAIL"))==0) { // Who knows? Maybe there're
		// braindamaged systems out there where login doesn't
		// setup $MAIL
		strcpy(spoolmbox_name, grc.get(0,0));
		strcat(spoolmbox_name, logname);
	}else
	strcpy(spoolmbox_name, _mailbox);
	FILE *s_mbox,*i_mbox;
	//	Need r+ rather then r because fcntl will fail otherwise
	if( (s_mbox=fopen(spoolmbox_name,"r+"))==0) {
//		printf("Hmm, no new mail in spool mbox\n");	
		return;
	}
	if( (i_mbox=fopen(inbox,"a"))==0) a_fatal(grc.get(1,10),1017);
	appendfile(i_mbox,s_mbox);	fclose(i_mbox);
	//	A kludge...
	if( (i_mbox=fopen(spoolmbox_name,"w"))==0)
		a_fatal(grc.get(1,5),1006);
	fclose(i_mbox); fclose(s_mbox); //	unlink(spoolmbox_name);
}

int	FolderBrowser::seek(int	msg)	
{
	last=first;for(int i=0;i<msg;++i)
	{
		if((last=last->getnext())==0) {
			a_print(grc.get(2,12));	return	0;
		}
	}	
	n_msg=msg;	return	1;
}
static	int	virgin=1,virgin_msg=1;
int	FolderBrowser::listsummary()
{
	if(virgin && the_rest)	if(!seek(atoi(the_rest))) return 0;
	char	headsum[161];	virgin=0;
	if(last->getlast()==0)	last=last->getnext();
	for(int	i=1;i<scr_lines; ++i,last=last->getnext(),++n_msg) {
		if(last==0)	{	rewind();	return	0; }
		last->headersummary(n_msg, headsum, scr_cols+1);
		a_print(headsum,161);putchar('\n');
	}
	return	1;
}
void	FolderBrowser::markallread()
{
	for(last=first;;) {
		if((last=last->getnext())==0) break;
		last->markread();
	}
}
uint	FolderBrowser::numread()
{	uint	_=0;
	for(last=first;;) {
		if((last=last->getnext())==0) break;
		_+=last->isread();
	}	return	_;
}
#include <signal.h>
#define	INSTALLCHECK	{ signal(SIGALRM,shadow); alarm(6); }
int	needchecking=0;
void	shadow(int)
{
	INSTALLCHECK needchecking=1;
	printf("time to check for new mail\n");
}
static	char *prevbox=inbox,*newbox=inbox;
static	Folder	*current_folder;	
void	checknew()
{	if(needchecking) {
		printf("%d %d\n",current_folder->browse.numread(),num_msgs);
		if(current_folder->browse.numread()==num_msgs) {
			printf("Checking for new mail...\n");
			received.close();
			uint _=cur_msg;
			if(checkfornewmail()==0) cur_msg=_;
			if(!received.open(prevbox)) a_print(grc.get(2,18));
		}
		needchecking=0;
	}
}

int	FolderBrowser::updatefolder()
{	if(restricted) return 0;
	FILE *fp; Rfc822Msg *_,*tmp; uint touched=0,deleted=0,total=0;
	char tfname[256];

	for(tmp=_=first;tmp=_->getnext();_=tmp) { touched|=tmp->touched();
			if( tmp->deleted() )	++deleted;	else ++total;
	}
	if(touched==0 || _==0)	goto changeit;
	if(deleted!=0) {
	//	Held XXX messages, deleted XXX 
		sprintf(tfname,	"%s %d %s%s %d\n", grc.get(3,6),total,
			grc.get(3,total!=1?7:9),grc.get(3,8),deleted);
	}else
	sprintf(tfname,		"%s %d %s\n",	grc.get(3,6),total,
			grc.get(3,total>1?7:9));
	a_print(tfname);
	strcpy(	tfname, homedir);
	strcat( tfname, grc.get(0,10));
	if((fp=fopen(tfname,"w"))==0) return 0;
	a_print(grc.get(2,16));
	for(tmp=_->getlast();tmp;_=tmp,tmp=_->getlast())
		if(_->save(fp)==0)	return 0;
	if(fclose(fp))	return 0;
	if(unlink(prevbox))	a_fatal(grc.get(1,17),1020); 
		// if it had failed here, recovering would've needed
	if(total || strstr(prevbox,grc.get(0,1)))
	if(link(tfname,prevbox))a_fatal(grc.get(1,18),1021);
	if(unlink(tfname))	a_fatal(grc.get(1,19),1022); 
changeit:
	received.close();
	checkfornewmail();
	return 1;
}
int	FolderBrowser::savefolder()
{	Rfc822Msg *_;
	if(updatefolder()==0) return 0;
changeit2:
	if(!received.open(newbox)) { a_print(grc.get(2,18)); newbox=prevbox;
						goto changeit2;
	}
	prevbox=newbox;
	for(_=first;_=_->getnext();) _->untouch();
	return 1;
}
void	rewind_message()
{	
	virgin_msg=1;
}
static
uint	measure_and_print_strings	(char *fieldname, char *contents)
{
	uint	charsonline = strlen(fieldname);a_print(fieldname,charsonline);
	char	*c_body=contents;	int	dsize=0;

#define INC	++c_body,++dsize

	for(int i=1;;INC) {
		if(*c_body=='\0')	goto	exiting;
		if(c_body[0]=='\n')
			if((c_body[1]!=' ') && (c_body[1]!='\t'))
				break;
			else{	charsonline=0; ++i; continue; }
		if(++charsonline>scr_cols) { charsonline=1;
			++i; continue; 
		}
	}	INC;
exiting:a_print(contents,dsize);
	return	i;
#undef	INC
}
void	Rfc822Msg::prefix_msg()
{
	if(reply_to)c_line+=measure_and_print_strings(grc.get(3,4),reply_to);
	if(date)    c_line+=measure_and_print_strings(grc.get(3,1),date);
	if(subject) c_line+=measure_and_print_strings(grc.get(3,2),subject);
	if(from)    c_line+=measure_and_print_strings(grc.get(3,3),from);
	if(cc)	    c_line+=measure_and_print_strings(grc.get(3,5),cc);
	c_line+=measure_and_print_strings("","\n");
}

int	FolderBrowser::listmessage()
{
	if(virgin_msg)	{ last->rewind(); last->prefix_msg(); virgin_msg=0; }
	return	last->dpaged();
}
int	FolderBrowser::savemessage(char *filename, char *fmode, int _)
{	
	if(_==0) return last->save(filename);
	FILE *fp;
	if(	(fp=fopen(filename,fmode))==0) return 0;
		if(last->save(fp,_)==0) { fclose(fp); return 0; }
	return	!fclose(fp);
}
inline	int	FolderBrowser::savemessage(int	_, FILE *fp)
{
	return last->save(fp,_);
}
inline	void	FolderBrowser::remove() {	last->remove(); }
inline	void	FolderBrowser::undelete() {	last->undelete(); }
#define PGPED (status&m_clearsigned || status&m_pgped)
int	Rfc822Msg::dpaged()
{	
	markread();
/*	if PGPED
	{
		if(!(status&m_checked)) {	status |=m_checked;
			char orig[32],msg_to_d[32]; tmpnam(msg_to_d);
			strcat(msg_to_d,"_orig"); strcpy(orig,msg_to_d);
			strcat(orig,".pgp");
			if(current_folder->browse.savemessage(orig,"w",3)==0) 
			{
				a_fatal(grc.get(1,24),1026); return 0;
			}
			char	*argv[]={ grc.get(0,26), orig, 0 };
			if(a_spawn(argv)) { status |= m_authen;
				AMemMap	afterpgp; caddr_t t; 
				c_body=body=t=afterpgp.map(msg_to_d,1);
				s_c_body=s_body=afterpgp.len();
			}
		}
		if(status&m_authen)
			a_print(grc.get(9,0));
		else	a_print(grc.get(9,1));
		char prot[3]; while((agets(prot,3,stdin))==0);
		switch(prot[0]) {
			case '\n': break;
			default:   return 0;
		}
	}*/
	uint	charsonline=0;	char	*todisplay=c_body;	int	more=1;
				uint	dsize=s_c_body;
#define INC	++c_body,--s_c_body
	for(int i=c_line;;INC) {
		if(s_c_body<=0 || *c_body=='\0') { more=0; goto noinc; }
		if(*c_body=='\n') { charsonline=0; if(++i<scr_lines) continue; 
			break;
		}
		if(++charsonline>scr_cols) { charsonline=1;
			if(++i<scr_lines) continue; 
			goto	noinc;
		}
	}	INC;
noinc:	dsize-=s_c_body;
	a_print(todisplay,dsize);
	c_line=1;	return	more;
}
void	rewind_index()	{	current_folder->index.rewind();	virgin=1; }

AMemMap	mappedfolder;
int	Folder::open(char *name) {	int	n_msg=0; cur_msg=1; num_msgs=0;
	close();
	if(access(name,F_OK|R_OK|W_OK))	return 0;
	struct flock locktype;
	locktype.l_type  =F_WRLCK;
	locktype.l_whence=SEEK_SET;
	locktype.l_start =0;
	locktype.l_len   =0;
	if((id=::open(name,O_RDWR|O_NONBLOCK))==-1) {
		printf("ERRNO %d",errno); a_fatal(grc.get(1,0),1037);
	}
	if(fcntl(id, F_SETLK, &locktype)==-1) a_fatal(grc.get(1,25),1036);
	folder=mappedfolder.map(name,1);
	char	*slider=folder;	size_t	slider_size=mappedfolder.len();
	while(slider_size>0) {	Rfc822Msg	*_;	++n_msg;
		_ = new Rfc822Msg(slider,slider_size);
		dummy.ins(_);
	}	fputc('\n',stdout); num_msgs=n_msg; return 1;
}
int	Folder::close() {	
	Rfc822Msg *_;
	while((_=dummy.getnext())) _->del();
	if(folder==0 || folder==(caddr_t)-1) return 1;
	if(mappedfolder.unmap()==0) { folder=0; return 0; }
	folder=0;
	if(id>0) ::close(id);
	return 1;
}
#include <dirent.h>
int	do_stat() {
	char fdir[256];
	strcpy(	fdir, homedir);
	strcat( fdir, grc.get(0,11));
	DIR *dir; struct dirent *d;
	if((dir=opendir(fdir))==0) a_fatal(grc.get(1,22),1024);
	while((d=readdir(dir)))	{
		if(d->d_name[0]=='.') continue;
		sprintf(fdir,"%s\n",d->d_name); a_print(fdir);
	}
	closedir(dir);
	a_print(grc.get(2,24));	printf("\t%s\n",prevbox);
	return 0;
}
int	do_mail_index()	{
	return	current_folder->index.listsummary();
}
inline	int	do_msg(uint _=cur_msg) {
	if(_>num_msgs ) { a_print(grc.get(2,20)); return 0; }
	else	if(_<1) { a_print(grc.get(2, 6)); return 0; }
		return 1;
}
int	do_message_(uint _) { if(do_msg(_)==0) return 0;
	return current_folder->browse.seek(_);
}
#define do_message if(do_message_()==0) return 0;
int	do_next()	{	if(do_msg(cur_msg)) ++cur_msg; return 0; }
//do_prev()	{	do_msg() --cur_msg; return 0; }
int	wasview=0;
int	do_display_message() {	wasview=0; do_message
	if(current_folder->browse.listmessage())	return 1;
	wasview=1;	++cur_msg;
	return 0;
}
int	do_save() {
if(!restricted) {
	do_message
	char reply[64];
	strcpy(reply,homedir);
	strcat(reply,grc.get(0,11));
	strcat(reply,"/"); int len=strlen(reply);
	if(the_rest) strcpy(reply+len,the_rest);
	else{	rp: a_print(grc.get(2,21)); 
		while(agets(reply+len,64,stdin)==0); }
	if(reply[len]=='?') { do_stat(); goto rp; }
	reply[strlen(reply)-1]='\0';
	printf("%s\n",reply);
	if(current_folder->browse.savemessage(reply,"a",3)==0)
	{	a_print(grc.get(2,15));
	}else{	// prompt for whether to delete
		a_print(grc.get(2,19)); while(agets(reply,3,stdin)==0);
		if(tolower(reply[0])=='y') do_delete_msg();
	}
}
	return 0;
}
int	do_download_message() {
	do_message	int _=0;
again:	a_print(grc.get(2,7));	char	prot[3], *d_cmd,msg_to_d[32]="/tmp/";
	while((agets(prot,3,stdin))==0);
	switch(prot[0]) {
		case 'a':	current_folder->browse.savemessage(_);
		case 'q':	return 0;
		case 'z':	d_cmd=grc.get(0,2); goto nonweirdfilename;
		case 'y':	d_cmd=grc.get(0,3); goto nonweirdfilename;
		case 'x':	d_cmd=grc.get(0,4); tmpnam(msg_to_d); break;
		case '?':	a_print(grc.get(5,11)); goto again;
		case 'h':	_=2;	a_print(grc.get(2,13)); goto again;
		case 'n':	_=1;	a_print(grc.get(2,14)); goto again;
nonweirdfilename:	a_print(grc.get(2,11));	
		while(agets(msg_to_d+strlen(msg_to_d),32,stdin)==0);
		if(strlen(msg_to_d)<1)	goto	failed;
		msg_to_d[strlen(msg_to_d)-1]='\0'; // supress trailing '\n'
		break;
		default :	return 0;
	}
	if(tolower(*the_rest)=='a') { _=2; // With headers to distinguish
		a_print(grc.get(2,42)); unlink(msg_to_d); int cm=cur_msg;
		for(cur_msg=1;cur_msg<num_msgs;++cur_msg) { do_message
		  if(current_folder->browse.savemessage(msg_to_d,"a",_)==0)
			;//had to ignore :-(	goto failed;
		}
		cur_msg=cm; // yes, ugly enuf :-[
	}else
	if(current_folder->browse.savemessage(msg_to_d,"w",_)==0) {
failed:		a_print(grc.get(2,15));
		return 0;
	}
	char	*argv[]={ d_cmd, msg_to_d, 0 };
	a_print(grc.get(2,8)); a_spawn(argv); unlink(msg_to_d); return 0;
}
int	do_delete_msg()	{
	do_message
	current_folder->browse.remove(); ++cur_msg;
	return 0;
}
int	do_undelete_msg() {
	do_message
	current_folder->browse.undelete();	
	return 0;
}
class	Smail	{ // Just for the matter of a proper cleanup
public:
	char memo[128],*bname;
	FILE *fp;
	Smail():bname(0){ fp=fopen(tmpnam(memo),"w+"); }
	void	close()	{ if(fp) fclose(fp); fp=0; }
	void	unlink(){ ::unlink(memo); ::unlink(bname); }
	~Smail()	{ close(); /*unlink();*/}
};
static	char	to[1024],subject[1024],cc[1024],references[512],ng[512];
#include "aglier.h"
char *send_mail_aglier()
{
	char *bname; if((bname=aglier())==0)	return 0;
	return bname;
}
char *forward_mail()
{
	static char bname[128]; FILE *body;
	if((body=fopen(tmpnam(bname),"w"))==0) return 0;
	fprintf(body,"------ Start of included message ------\n");
	if(current_folder->browse.savemessage(2,body)==0) return 0;
	fprintf(body,"------ End of included message ------\n");
	fclose(body);
	return bname;
}
inline void trailproperly(char *_) {
	if(_[strlen(_)-1]!='\n') strcat(_,"\n");
}
int	sendmailer=15;
void	send_mail(int _=0,char *(*composer)()=send_mail_aglier)
{
	if(restricted)	return;
	Smail	s;	if(s.fp==0)		goto nomail;
	if(references[0]!='\0') {
		if(fputs(grc.get(0,5), s.fp)==EOF)	goto nomail;
		if(fputs(references, s.fp)==EOF)	goto nomail;
	}
	if(ng[0]!='\0') {
		if(fputs(grc.get(0,32), s.fp)==EOF)	goto nomail;
		if(fputs(ng, s.fp)==EOF)		goto nomail;
	}
	if(to[0]=='\0' || to[0]=='\n') goto nomail;
	if(to[0]==',') { to[0]=' ';
		if(fprintf(s.fp,"%s%s%s\n",	grc.get(0,34), logname,
						grc.get(0,31))<0) goto nomail;
	}
	if(fputs(grc.get(0,16), s.fp)==EOF) goto nomail;
	trailproperly(to);
	if(fputs(to, s.fp)==EOF)	goto nomail;
	if(_)	{	a_print(grc.get(2,26)); a_print(to); }
	if(sendmailer==15) {
	if(subject[0]=='\n'||subject[0]=='\0'||fputs(grc.get(0,17), s.fp)==EOF)
		goto nomail;
	if(fputs(subject, s.fp)==EOF)	goto nomail;
	if(_)	{	a_print(grc.get(2,27)); a_print(subject); }
	}// if sendmailer...
	if(cc[0]!='\0' && cc[0]!='\n') { 
		if(fputs(grc.get(0,20), s.fp)==EOF)	goto nomail;
		if(fputs(cc, s.fp)==EOF)	goto nomail;
		if(_)	{	a_print(grc.get(2,28)); a_print(cc); }
	}if(sendmailer!=15)
	if(fprintf(s.fp,"From: %s%s\n", logname, grc.get(0,31))<0) goto nomail;
	if(fputs("X-Mailer: GNOS 1.10\n\n", s.fp)==EOF) goto nomail;
	if((s.bname=(*composer)())==0)	goto nomail;
#define	agetch(string) \
	{ while((agets(string,3,stdin))==0); \
	  if(string[0]!='\n') while(string[1]!='\n') string[1]=fgetc(stdin); \
	}
retry:	a_print(grc.get(2,38));	char prot[3]; 
	agetch(prot) //while((agets(prot,3,stdin))==0);
	switch(prot[0]) {
		case 'e': if(a_editor(s.bname)) goto nomail;
			goto retry;
		case '\n': break;
		case 'q': goto nomail;
		default: goto retry;
	}
	{ FILE *body; char *outfile=s.bname;
	  if(auth) if(a_sign(s.bname, outfile)) goto nomail;
	  if( (body=fopen(outfile,"r"))==0) goto nomail;
	  appendfile(s.fp, body, 0); s.close(); aglier_clean();
	  ::unlink(outfile);
	  if(sendmailer==15) {
	    char	*argv[]={ grc.get(0,15), "-i", "-t", 0 };
	    if(a_spawn(argv,s.memo,0)==0) goto nomail;
	  }else{
	    sendmailer=15;
	    char	*argv[]={ grc.get(0,15), "-i", "-t", 0 };
	    if(a_spawn(argv,s.memo,0)==0) goto nomail;
//	    char	*argv[]={ grc.get(0,30), s.memo, 0 };
//	    if(a_spawn(argv,0,"/dev/null","/dev/null")==0) goto nomail;
	  }
	}
	a_print(grc.get(2,30)); s.unlink(); return;
nomail:	a_print(grc.get(2,29)); return;
}
#define	GETTOSUBJ \
	current_folder->browse.get_reply_to(to); \
	if(to[0]=='\0') \
		current_folder->browse.get_from(to); \
	current_folder->browse.get_subject(subject); \
	current_folder->browse.get_message_id(references);

int	do_reply_all()
{
	do_message
	current_folder->browse.get_cc(cc);	
	GETTOSUBJ
	int _;
	if((_=strlen(to))>0) {
		to[_-1]=',';
		current_folder->browse.get_to(to+_);
	}
	send_mail(1);	return 0;
}
int	do_reply() {
	do_message
	GETTOSUBJ
	send_mail(1);	return 0;
}
int	do_usenet() {
	if(the_rest) strcpy(ng,the_rest); else
	{
	a_print(grc.get(8,7));  while(agets(ng,		512,stdin)==0);
	}
	references[0]='\0';
	a_print(grc.get(2,27)); while(agets(subject,	1024,stdin)==0);
	strcpy(to,grc.get(0,33));
	send_mail();	return 0;
}
int	do_mail() {
	if(the_rest) strcpy(to,the_rest); else
	{
	a_print(grc.get(2,26)); while(agets(to,		1024,stdin)==0);
	}
	if(sendmailer==15) {
	a_print(grc.get(2,27)); while(agets(subject,	1024,stdin)==0); }
	a_print(grc.get(2,28)); while(agets(cc,		1024,stdin)==0);
	references[0]='\0';
	send_mail();	return 0;
}
int	do_forward() {
	do_message
	a_print(grc.get(2,26)); while(agets(to,		1024,stdin)==0);
	a_print(grc.get(2,27)); while(agets(subject,	1024,stdin)==0);
	if(subject[0]=='\n') {
		current_folder->browse.get_exactsubject(subject);
		if(subject[0]!='\0');
			subject[strlen(subject)-1]=' ';
		strcat(subject,"(fwd)\n");
	}
	a_print(grc.get(2,28)); while(agets(cc,		1024,stdin)==0);
	references[0]='\0';
	send_mail(0,forward_mail);	return 0;
}
int	do_pretend_mail_read() {
	current_folder->browse.markallread();	return 0;
}
int	do_dispatch_write() { int theend=0;
	if(do_message_()==0) theend=1;
retry:	a_print(grc.get(2,25));	char reply[3];
	while(agets(reply,3,stdin)==0);
	switch(reply[0]) {
		case 'q':	return 0;
		case 'r': if(theend) goto mail;
			a_print(grc.get(2,39)); while(agets(reply,3,stdin)==0);
			if(reply[0]=='q') return 0;
			if(reply[0]=='e') goto mcast;
/*private*/	case 'p':	if(theend) goto mail; return do_reply();
/*multicast*/	case 'R':mcast:	if(theend) goto mail; return do_reply_all();
		case 'm':
		case 'n':mail:	return do_mail();
		case 'c':	// forward to...
		case 's':	if(theend) goto mail; return do_forward();
		case 'f':
		case 'F':	char	faxno[32],faxaddr[128],
					surname[32],orgaddr[32];
			if(!the_rest)
		{ the_rest=faxno;
		  a_print(grc.get(2,41)); while(agets(the_rest,32,stdin)==0);
		}
#define	a_gets(set,inset,string) { a_print(grc.get(set,inset)); \
	while(agets(string,sizeof string,stdin)==0); \
	string[strlen(string)-1]='\0'; }
#define despacing(string) { char *_; \
		while((_=strpbrk(string," \t"))) *_='_'; \
	}
			the_rest[strlen(the_rest)-1]='\0';
			if(!isdigit(the_rest[0])) goto retry;
		//	strcat(the_rest,grc.get(0,28));
		strcpy(faxaddr,"remote-printer.");
		  a_gets(2,44,surname) despacing(surname)
		  a_gets(2,45,orgaddr) despacing(orgaddr)
		if(strlen(surname)>0) {
			strcat(faxaddr,surname);
			strcat(faxaddr,"/");
		}
		strcat(faxaddr,orgaddr);
		strcat(faxaddr,"@");
		strcat(faxaddr,the_rest+2);
		strcat(faxaddr,".iddd.tpc.int");
			the_rest=faxaddr;
		//	strcat(the_rest,grc.get(0,28));
			sendmailer=30; goto mail;
/*USENET*/	case 'u':	return do_usenet();
		default:	goto retry;
	}
}
do_deletefolder()
{
	if(prevbox==newbox)	if(prevbox==boxn2)	newbox=boxn1;
				else			newbox=boxn2;
	strcpy(	newbox, homedir);
	strcat( newbox, grc.get(0,11));
	strcat( newbox, "/");
	char	_[64],*newfolder=_;
	if(the_rest!=0)	newfolder=the_rest;
	else {rp:a_print(grc.get(2,21)); while(agets(newfolder,64,stdin)==0); }
	if(newfolder[0]=='?') { do_stat(); goto rp; }
	newfolder[strlen(newfolder)-1]='\0';
	if(newfolder[0]!='\0') {
		strcat( newbox, newfolder);
		if(strstr(newbox,grc.get(0,1))) return 0; // main mailbox
		struct stat buf;
		if( stat(newbox, &buf))	return 0;
		if( buf.st_size > 0) 
		{
			a_print(grc.get(2,43)); char prot[3];
			agetch(prot)
			if(prot[0]!='y') return 0;
		}
		if(unlink(newbox)) a_print(grc.get(2,18));
		printf("%s\n",newbox);
	} return 0;
}
do_gofolder()
{
	if(prevbox==newbox)	if(prevbox==boxn2)	newbox=boxn1;
				else			newbox=boxn2;
	strcpy(	newbox, homedir);
	strcat( newbox, grc.get(0,11));
	strcat( newbox, "/");
	char	_[64],*newfolder=_;
	if(the_rest!=0)	newfolder=the_rest;
	else {rp:a_print(grc.get(2,21)); while(agets(newfolder,64,stdin)==0); }
	if(newfolder[0]=='?') { do_stat(); goto rp; }
	newfolder[strlen(newfolder)-1]='\0';
	if(newfolder[0]!='\0') {
		strcat( newbox, newfolder);
		printf("%s\n",newbox);
		current_folder->browse.savefolder();
	} return 0;
}
do_update_folder()
{
	newbox=prevbox;
	current_folder->browse.savefolder();	return 0;
}
ARc arc;
do_english()
{
	arc.locale=0;
	grc.read(NLSPATHENG); return 0;
}
do_russian()
{
	arc.locale=1;
	grc.read(NLSPATHRUS); return 0;
}
void	a_mua()
{
	checkfornewmail();
	current_folder=&received;
	if(!received.open(inbox))	a_fatal(grc.get(1,20),1023);
}
static char rcname[256];
do_quit() {	if(restricted) exit(0);
	current_folder->browse.updatefolder();
	FILE *fp; arc.encoding=do_enc();
		  arc.i_encoding=doienc();
	if((fp=fopen(rcname,"w"))!=0) {
		fwrite(&arc,sizeof(arc),1,fp); fclose(fp);
	}
	exit(0);
}
do_exit() { exit(0); }

int	main(int argc, char *argv[])
{	do_english();
	if((logname=getlogin())==0) {	a_fatal(grc.get(1,11),1012);	}
	strcpy(	rcname, homedir);
	strcat( rcname, grc.get(0,11)); mkdir(rcname,0700);
	strcpy(	rcname, homedir);
	strcat( rcname, grc.get(0,23)); FILE *fp;

	if(access(rcname,F_OK)==0) { a_print(grc.get(2,33));
	 	if((fp=fopen(rcname,"r"))!=0) 
		for(int ch;;fputc(ch,stdout))
			if((ch=fgetc(fp))==EOF) break;
		exit(0);
	}
	strcpy(	rcname, homedir);	strcat( rcname, grc.get(0,22));
	if(access(rcname,F_OK)==0) {	restricted=1; a_print(grc.get(2,34)); }
	strcpy(	rcname, homedir);	strcat( rcname, grc.get(0,27));
	if(access(rcname,F_OK)==0 || !getgid())
				{	auth=1; /*a_print(grc.get(,));*/ }
	strcpy(	rcname, homedir);	strcat( rcname, grc.get(0,21));
	if((fp=fopen(rcname,"r"))!=0) {
		if(fread(&arc,sizeof(arc),1,fp)<1) a_print(grc.get(2,31));
		fclose(fp);
		if(arc.locale)	do_russian();
		do_enc(arc.encoding);
		doienc(arc.i_encoding);
	}else{	doienc(1);do_russian(); }
/*	if(getenv(grc.get(0,7))) {
		printf("You're working from UNIX, aren'y (y/n) ?");
		admin=1; char reply[3]; while(agets(reply,3,stdin)==0);
		if(reply[0]=='y') doienc(0);
		else doienc(1);
	}*/
//--------------------------------------------------
	if(argc>1) { the_rest=argv[1]; do_mail();
		exit(0);
	}
	a_print(grc.get(2,0));
	a_mua(); //INSTALLCHECK
	do_prompt();
}

//	EOF $Id: a_mua.g,v 3.11 1994/10/12 11:03:34 agl Exp agl $
