//	$Id: a_mua.h,v 1.4 1994/02/23 13:31:21 agl Exp agl $
//
#include "a_stdio.h"
typedef	unsigned	uint;

const	uint	
	m_deleted	=1,
	m_read	=4,
	m_old	=8,
	m_clearsigned=16, m_pgped=32, m_checked=0x40, m_authen=0x80;

class	Rfc822Msg	{
	char	*header;	uint	s_header;// with trailing newline
	char	*body, *c_body;	uint	s_body; // with trailing newline
	uint	status,	changed, s_c_body, c_line;
	uint	n_lines, n_chars, n_mesg;
	Rfc822Msg	*last,*next;
	char	*from,
		*date,
		*subject,
		*reply_to,
		*to,
		*cc,
		*_status,
		*message_id;
void	get(char *field, char *dest);
public:
	Rfc822Msg()	{	last=0;	next=0;	changed=0; }	
	uint	touched()	{	return	changed; }
	void	untouch()	{	changed=0; }
	uint	deleted()	{	return	status&m_deleted; }
	uint	isread()	{	return	status&m_read?1:0; }
#define _get(field) \
	void	get_##field(char *_)	{	get(field,_); }
	_get(to)
	_get(cc)
	_get(from)
	_get(reply_to)
	_get(message_id)
	void	get_exactsubject(char *_){	get(subject,_); }
	void	get_subject(char *_)	{	char	*i=subject;
		if(i==0) { strcpy(_,
		"descriptive subjects considered to be a Good Thing\n");
			return;
		}
		for(;*i==' '||*i=='\t';++i);
		if(i[0]!='R'||i[1]!='e'||i[2]!=':') { strcpy(_,"Re: "); _+=4; }
		get(i,_);
	}
	Rfc822Msg(char *&msg, size_t &size);	

	void	ins(Rfc822Msg	*_)	{
		if((_->next=next)!=0)
			next->last=_;
			next=_;
		_->last=this;
	}
	void	del()	{
		if(last!=0)	last->next=next;
		if(next!=0)	next->last=last;
		delete	this;
	}
	void	headersummary(uint n_msg, char	*summary, uint	len);
	void	prefix_msg();
	void	rewind()	{ c_line=1; c_body=body; s_c_body=s_body; }
	void	rewindh()	{ c_line=1; c_body=header; 
					s_c_body=s_body+s_header/*-1*/;
				}
	int	markread()	{	if(status&m_read)	return 0;
					status|=m_read;	changed|=1;
					if(_status) { *_status='R'; return 1; }
					return 1;
				}
	int	dpaged(),save(char *);
		save(FILE *fp,int mode)	{
			switch(mode) {
			case 1:
				return	a_print(body,s_body,fp);
			case 2:
				if(	a_print(header,s_header,fp)==0)
					return 0;
				return	a_print(body,  s_body,fp);
			case 3:
				if(	anprint(header,s_header,fp)==0)
					return 0;
				return	anprint(body  ,s_body,fp);
			default:return s_body>0?a_print(body,s_body,fp):1;
			}
		}
		save(FILE *fp)	{	if(deleted())	return 1;
			if(_status) return
				anprint(header,s_header+s_body,fp);
			if(anprint(header,s_header-1,fp)==0) return 0;
			if(fputs("Status: ",fp)==EOF)	return 0;
			if(status&m_read) { if(fputc('R', fp)==EOF) return 0; }
			else
				if(fputc('O', fp)==EOF) return 0;
			if(fputs("\n\n",fp)==EOF) return 0;
			return s_body>0?anprint(body,s_body,fp):1;
		}
	void	remove()	{	status|=m_deleted; changed|=2; }
	void	undelete()	{	status&=~m_deleted;changed&=~2;	}
	Rfc822Msg	*getnext()	{	return	next;	}
	Rfc822Msg	*getlast()	{	return	last;	}
};

class	HomeDir	{
	char	*homedir;
public:
	HomeDir();
	operator char *();
};	extern	HomeDir	homedir;

extern	uint	scr_lines,scr_cols,cur_msg,num_msgs;
extern	int	do_display_message(),	do_download_message(), do_save(),
		do_mail_index(),	do_dispatch_write(), do_forward(),
		do_mail(),	do_reply(),	do_reply_all(), do_stat(),
		do_delete_msg(),do_undelete_msg(), do_deletefolder(),
		do_exit(),	do_pretend_mail_read(), do_update_folder(),
		do_gofolder(),	do_next(),	do_english(), do_russian(),
		do_quit(), do_exit();
extern	int	do_message_(uint _=cur_msg);
		// Main loop
extern	void	do_prompt(),checknew();
extern	void	rewind_index(),	
		rewind_message();
extern	char	*the_rest;
extern	int	wasview, restricted;
//	EOF $Id: a_mua.h,v 1.4 1994/02/23 13:31:21 agl Exp agl $
