//	AGL(C)	1994
//	$Id: cmds.g,v 2.6 1994/10/12 11:03:57 agl Exp agl $
//
#include <time.h>
#include <ctype.h>
#include <string.h>
#include "localize.h"
#include "a_stdio.h"
#include "a_mua.h"
#include "_usenet.h"
#include "_internet.h"

static	int	do_help(int);
int	do_brief_help()		{	return do_help(4); } 
int	do_comprehensive_help() {	return do_help(5); }
extern	int	do_mmode(),do_conf(),do_passwd(),do_www(),do_wwwk();

struct	cmd	{	
	int	(*action)();	void	(*rewind)();
	char	*alias;		int	rc_minor,	is_multi;
//	void	(*action2)();
};
static	void	rewind_help();
static
cmd	c_cmds[] = {
//	{	do_display_article,	rewind_article,
//					"", -1, 0 },
	{	do_mmode,	0,	"mail", -1, 0 },
//	{	do_pretend_conf_read,	"pretend" }
	{	do_news_index,	0,	"index", 3, 0 },
	{	do_dispatch_post, 0,	"write", 4, 0 },
	{	0,		0	}
};

static
cmd	m_cmds[] = {
	{	do_display_message,	rewind_message, 
					"",	-1,0 }, // *ought to* be first!
	{	do_k2a,		0,	"k2a",	0 },
	{	do_null,	0,	"Null",	1 },
	{	do_a2k,		0,	"a2k",	2 },
	{	do_strip8,	0,	"strip8",5 },
	{	doinull,	0,	"ADMIN",-1 },
	{	doia2k,		0,	"luser",-1 },

	{	do_next,	0,	"next",-1},
	{	do_mail_index,	rewind_index,	"index",3 },
	{	do_download_message,	0,	"capture" , 10, 0 },
	{	do_download_message,	0,	"Download", -1, 0 },
	{	do_delete_msg,	0,	"delete",	12, 1 },
	{	do_undelete_msg,0,	"undelete",	13, 1 },
	{	do_save,	0,	"save",	19, 0 },
	{	do_deletefolder,0,	"rm", 26, 0 },
	{	do_mail,	0,	"mail",	16, 0 },
	{	do_reply,	0,	"reply", 17, 0 },
	{	do_reply_all,	0,	"Reply", 18, 0 },
	{	do_forward,	0,	"forward",-1,0 },
	{	do_dispatch_write, 0,	"write", 4, 0 },
	{	do_stat,	0,	"STat",	22, 0 },
	{	do_gofolder,	0,	"go",	15, 0 },
	{	do_pretend_mail_read,	0,		"pretend",	8, 0},
	{	do_update_folder,	0,		"Update",	14, 0},

	{	do_telnet,	0,	"telnet",	27, 0 },
	{	do_finger,	0,	"finger",	30, 0 },
	{	do_talk,	0,	"talk",		28, 0 },
	{	do_ftp,		0,	"ftp",		31, 0 },
	{	do_gopher,	0,	"gopher",	29, 0 },
	{	do_www,		0,	"WWW",		25, 0 },
	{	do_wwwk,	0,	"WWWK",		-1, 0 },
	{	do_brief_help,		rewind_help,	"?",	6, 0},
	{	do_comprehensive_help,	rewind_help,	"help",	7, 0},
	{	do_quit,	0,	"quit",	9, 0 },
	{	do_exit,	0,	"exit",	24, 0 },
	{	do_conf,	0,	"conf", -1, 0 },
	{	do_english,	0,	"english",20,0 },
	{	do_russian,	0,	"cyrillic",21,0 },
	{	do_passwd,	0,	"passwd",23,0},
	{	0,		0,	0,	0 }
};
cmd	*mail_mode[]={ m_cmds, c_cmds, 0 };
cmd	*conf_mode[]={ c_cmds, m_cmds, 0 };
cmd	**inorder=mail_mode; int gnosmode=0;
int
do_mmode()	{	inorder=mail_mode; gnosmode=0; return 0; }
int
do_conf()	{	inorder=conf_mode; gnosmode=1; return 0; }
int
do_passwd() {
	if(restricted) return 0;
	char	*argv[]={ grc.get(0,25), 0 };
	a_print(grc.get(2,40)); a_spawn(argv); return 0;
}
/*int
do_www() {
	if(restricted) return 0;
	char	*argv[]=
		{ grc.get(0,29), grc.get(0,35), "-koi2alt", "-h", "localhost", 0 };
	a_spawn(argv); return 0;
}
int
do_wwwk() {
	if(restricted) return 0;
	char	*argv[]=
		{ grc.get(0,29), grc.get(0,35), "-h", "localhost", 0 };
	a_spawn(argv); return 0;
}*/
int	iscontinue=0;
char	*the_rest=0;
void	do_prompt()	{	char	cmdbuf[64],*gotcmd,*cont=""; 
//	struct tm *_=localtime(time(0));
//	printf("(%d:%d) ",_->tm_hour,_->tm_min);
	cmd	**_,*c,*c_match=m_cmds;
	for(;;) {
		char	prompt[256];
		if(gnosmode)
			sprintf(prompt,"Conf%s > ", cont);
		else
			sprintf(prompt,"#%u %s %u%s > ", cur_msg==0?0:
					(wasview?cur_msg-1:cur_msg),
				grc.get(3,0), num_msgs, cont); a_print(prompt);
		while(agets(gotcmd=cmdbuf,64,stdin)==0); checknew();
		if(gotcmd[0]=='\n') {
			if(!iscontinue) if(gnosmode==0) {
display_message:	    	if(c_match->rewind) c_match->rewind();
				c_match=*inorder; // do_display_message
			}	goto	doit;
		}
#define	ADJUST(char_ptr,action) \
		while(*char_ptr==' ' || *char_ptr=='\t') { *char_ptr++='\0'; \
			if(*char_ptr=='\0')	action; \
		}
		ADJUST(gotcmd,goto newcmd)
		if(strchr(gotcmd,'.')!=0)
		{
			if(go_newsgroup(gotcmd)==0) continue;
		}
		if((the_rest=strchr(gotcmd,' '))==0)
			if((the_rest=strchr(gotcmd,'\t'))==0)
				gotcmd[strlen(gotcmd)-1]='\0';
			else	ADJUST(the_rest, the_rest=0)
		else		ADJUST(the_rest, the_rest=0)
		if(isdigit(gotcmd[0])) {	//uint	_;
			if(do_message_(cur_msg=atoi(gotcmd))==0) continue;
/*
			if( (_=atoi(gotcmd)) > num_msgs) {
				a_print(grc.get(2,12)); continue;
			}if(_<1) {
				continue;
			}
			cur_msg=_;
*/
			goto	display_message;
		}
		{//newcmd scope
	    	if(c_match->rewind) c_match->rewind();
		unsigned	wasmatch=0, /*complen,*/ match;
		for(_=inorder;*_;++_)
		{
			for(match=0,c=*_;c->alias;++c)
			{	if(strncmp(
					gotcmd,c->alias,strlen(gotcmd))==0) {
					c_match=c;
					if(	strlen(c->alias)==
						strlen(gotcmd))	goto	doit;
					++match;	
				}
			}
			if(match>1) {	a_print(grc.get(2,4)); goto newcmd; }
			if(match>0) {	wasmatch=1; break; }
		}
		if(!wasmatch) { a_print(grc.get(2,5)); continue; }
		if(wasview) { wasview=0; --cur_msg; }
		/*newcmd scope*/}
doit:		if(c_match->is_multi && the_rest)
		{
			char	lc[64],hc[64],*_=lc;
			int	high_range=0,h;
			for(;*the_rest!='\0';++the_rest) {
				if(*the_rest==':' || *the_rest=='-')
				{	*_='\0';
					high_range|=2; _=hc; continue; }
				if(isdigit(*the_rest)) {*_++=*the_rest;
							high_range|=1; }
				else{	// separator
					if(high_range<1) { _=lc;continue; }
					*_='\0'; uint i=cur_msg;
					if(strlen(lc)) cur_msg=atoi(lc);
					else cur_msg=1;
					if(high_range>1) { 
						if(strlen(hc)) h=atoi(hc);
						else h=num_msgs;
						for(uint _=cur_msg;_<=h;++_)
						{	cur_msg=_;
//						printf("_ms %d ",cur_msg);
						c_match->action();
						}
						high_range=0;
					}else
//						printf("_msg %d\n",cur_msg);
						c_match->action();
					_=lc;  cur_msg=i;
				}
			}
			iscontinue=0; cont=""; goto	newcmd;
		}else
		if((iscontinue=c_match->action())) {
			cont=grc.get(2,17);
		}else{	cont="";
			goto	newcmd;
		}
newcmd:;}
}


static	cmd	*help_c=m_cmds;	
static	void	rewind_help()	{	help_c=/*m_cmds*/*inorder; }
static	int	do_help(int	rc_major)
{
	char	helpbuf[1024],*separator;
	for(int i=0;i<scr_lines-1;++help_c)
	{	if(help_c->rc_minor<0)	continue;
		if(help_c->alias==0)	return 0;
		int _=strlen(help_c->alias);
		if(the_rest!=0 && strncmp(the_rest,help_c->alias,_)!=0)
			continue;
		if(_<8)	separator="\t\t";
		else	separator="\t";
		sprintf(helpbuf,"%s%s%s\n",help_c->alias, separator,
					grc.get(rc_major,help_c->rc_minor));
		for(separator=helpbuf;*separator;++separator)
			if(*separator=='\n' && ++i>=scr_lines-1) return 1;
		a_print(helpbuf);
	}
	return	1;
}

//	EOF $Id: cmds.g,v 2.6 1994/10/12 11:03:57 agl Exp agl $
