#!/usr/bin/perl

# Script to give a compact listing of the smail queue

# Philip Hazel <ph10@cus.cam.ac.uk>
# July 1993


$spool   = "/var/spool/smail";

# Get the list of current files, and loop for each one

@filelist = split(/\s/, `ls $spool/input`);

foreach $file (@filelist)
  {
  # Process the spool file and the msglog file and mail the sender

  open(SPOOL, "<$spool/input/$file");

  # Set into paragraph mode and suck in the entire spool file header;
  # then get the sender from a -f flag or the user who wrote the file.

  $/ = "";
  $_ = <SPOOL>;
  ($sender) = $_ =~ /\n!-f\n!(\S+)\n/;
  ($sender) = $_ =~ /^!(\S+)/ if $sender eq "";

  ($id, $site) = $sender =~ /^(\S+)@(\S+)$/;
  $sender = $id if $site eq "glas.apc.org";

  close(SPOOL);

  # Open the corresponding msglog file; scan through for
  # anything other than Xdefer, and remove the corresponding
  # addresses. Just for defensiveness, ensure that anything
  # that is deferred is on the list.

  open(MSGLOG, "<$spool/msglog/$file") || next;
  undef %destlist;
  $/ = "\n";
  $* = 0;
  while (<MSGLOG>)
    {
    ($dest) = $_ =~ /<+([^>\s]+)>+/;
    if ($_ =~ /^Xdefer/) { $destlist{$dest} = 1; }
      else { delete $destlist{$dest}; }
    }
  close(MSGLOG);

  if (keys %destlist > 0)
    {
    foreach $key (keys %destlist)
      {
      printf "%14s %8s  $key\n", $file, $sender;
      $file = "";
      $sender="";
      }
    }
  else
    {
    printf "%14s %10s\n", $file, $sender;
    }
  }

# End of mq
