#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MmHelp.c,v 1.2 1994/03/31 17:57:18 dwb Exp $";
#endif


/*
 * $Log: MmHelp.c,v $
 * Revision 1.2  1994/03/31  17:57:18  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:52:53  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <string.h>

#include "MmDecl.h"
#include "MuGeneric.h"

#ifndef HELPFILE
#define HELPFILE "/usr/lib/X11/mumail.help"
#endif

#define HELP_DELIMITER ""

void
DisplayHelpText(scn, topicName)
	 SCREEN          *scn;
	 String          topicName;
{
  static String          wholeBuffer;
  String                 bufferStart;

  if (wholeBuffer == NULL) wholeBuffer = CopyFileToBuffer(HELPFILE);
  if (wholeBuffer == NULL) 
	{SimpleMessage(scn, "Could not load help file"); return;}

  if ((bufferStart = Strstr(wholeBuffer, FmtString("%s\n%s", HELP_DELIMITER, 
													topicName))))
	bufferStart += strlen(HELP_DELIMITER);
  else bufferStart = wholeBuffer;

  DisplayBufferInBodyBox(scn, bufferStart);
}

/* ARGSUSED */
void
HelpAllCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "ALL");
}

/* ARGSUSED */
void
HelpOverviewCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "NAME");
}

/* ARGSUSED */
void
HelpResourcesCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "RESOURCES");
}

/* ARGSUSED */
void
HelpOptionsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "OPTIONS");
}

/* ARGSUSED */
void
HelpMailAgentsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "MAIL DELIVERY AGENTS");
}

/* ARGSUSED */
void
HelpAliasesCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "ALIASES");
}

/* ARGSUSED */
void
HelpMimeCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "MIME SUPPORT");
}

/* ARGSUSED */
void
HelpMenusCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "MENUS");
}

/* ARGSUSED */
void
HelpBindingsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "MOUSE AND KEY BINDINGS");
}

/* ARGSUSED */
void
HelpQuickKeysCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "QUICK KEYS");
}

/* ARGSUSED */
void
HelpFilesCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "FILES");
}

/* ARGSUSED */
void
HelpBugsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "BUGS");
}

/* ARGSUSED */
void
HelpCopyrightCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "COPYRIGHT");
}

/* ARGSUSED */
void
HelpAuthorCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "AUTHOR");
}

/* ARGSUSED */
void
HelpAckCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "ACKNOWLEDGEMENT");
}

/* ARGSUSED */
void
HelpNewsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  DisplayHelpText((SCREEN*)clientData, "NEWS/CHANGES");
}
