#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MmMain.c,v 1.2 1994/03/31 17:57:28 dwb Exp $";
#endif


/*
 * $Log: MmMain.c,v $
 * Revision 1.2  1994/03/31  17:57:28  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:52:57  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmMain.c --- Main module
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Thu Jul  1 00:32:11 1993
 * Update Count    : 47
 * Status          : Mostly OK, needs some cleaning up
 */

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/xpm.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/extensions/shape.h>
#if USE_3D_FRAME
#include "Xfwf/Frame.h"
#endif

#include "MmDecl.h"
#include "MuWin.h"
#include "MuGeneric.h"
#define IS_MAIN
#include "version.h"

extern int
                CompareLettersByDateProc __P((Letter **l1, Letter **l2)),
                CompareLettersBySubjectProc __P((Letter **l1, Letter **l2)),
                CompareLettersByNameProc __P((Letter **l1, Letter **l2));

extern void
                HighlightToEndOFLineAction __P((Widget w, 
                                                XEvent *ev, 
                                                String *parm, 
                                                Cardinal *numParm)),

                BodyBoxNextPageAction __P((Widget w, 
                                           XEvent *ev, 
                                           String *parm, 
                                           Cardinal *numParm)),
                BodyBoxPrevPageAction __P((Widget w, 
                                           XEvent *ev, 
                                           String *parm, 
                                           Cardinal *numParm)),
                BodyBoxNextLineAction __P((Widget w, 
                                           XEvent *ev, 
                                           String *parm, 
                                           Cardinal *numParm)),
                BodyBoxEndOfPageAction __P((Widget w, 
                                           XEvent *ev, 
                                           String *parm, 
                                           Cardinal *numParm)),
                CloseWindowAction __P((Widget w, 
                                       XEvent *ev, 
                                       String *parm, 
                                       Cardinal *numParm)),
                IconifyWindowAction __P((Widget w, 
                                         XEvent *ev, 
                                         String *parm, 
                                         Cardinal *numParm)),
                OpenFolderAction __P((Widget w, 
                                      XEvent *ev, 
                                      String *parm, 
                                      Cardinal *numParm)),
                SaveFolderAction __P((Widget w, 
                                      XEvent *ev, 
                                      String *parm, 
                                      Cardinal *numParm)),
                CommitChangesAction __P((Widget w, 
                                         XEvent *ev, 
                                         String *parm, 
                                         Cardinal *numParm)),
                FolderInfoAction __P((Widget w, 
                                      XEvent *ev, 
                                      String *parm, 
                                      Cardinal *numParm)),
                QuickExitAction __P((Widget w, 
                                     XEvent *ev, 
                                     String *parm, 
                                     Cardinal *numParm)),
                ExitAction __P((Widget w, 
                                XEvent *ev, 
                                String *parm, 
                                Cardinal *numParm)),
                DisplayLetterGeneralAction __P((Widget w, 
                                                XEvent *ev, 
                                                String *parm, 
                                                Cardinal *numParm)),
                RedisplayCurLetterPartialAction __P((Widget w, 
                                                     XEvent *ev, 
                                                     String *parm, 
                                                     Cardinal *numParm)),
                RedisplayCurLetterWholeAction __P((Widget w, 
                                                   XEvent *ev, 
                                                   String *parm, 
                                                   Cardinal *numParm)),
                TagUntagLetterAction __P((Widget w, 
                                          XEvent *ev, 
                                          String *parm, 
                                          Cardinal *numParm)),
                RetagLettersAction __P((Widget w, 
                                        XEvent *ev, 
                                        String *parm, 
                                        Cardinal *numParm)),
                DeleteLetterAction __P((Widget w, 
                                        XEvent *ev, 
                                        String *parm, 
                                        Cardinal *numParm)),
                UndeleteLetterAction __P((Widget w, 
                                          XEvent *ev, 
                                          String *parm, 
                                          Cardinal *numParm)),
                ComposeLetterAction __P((Widget w, 
                                         XEvent *ev, 
                                         String *parm, 
                                         Cardinal *numParm)),
                ReplyToLetterAction __P((Widget w, 
                                         XEvent *ev, 
                                         String *parm, 
                                         Cardinal *numParm)),
                ForwardLetterAction __P((Widget w, 
                                         XEvent *ev, 
                                         String *parm, 
                                         Cardinal *numParm)),
                ExternalComposeLetterAction __P((Widget w, 
                                                 XEvent *ev, 
                                                 String *parm, 
                                                 Cardinal *numParm)),
                CopyLetterAction __P((Widget w, 
                                      XEvent *ev, 
                                      String *parm, 
                                      Cardinal *numParm)),
                RefileLetterAction __P((Widget w, 
                                        XEvent *ev, 
                                        String *parm, 
                                        Cardinal *numParm)),
                LetterInfoAction __P((Widget w, 
                                      XEvent *ev, 
                                      String *parm, 
                                      Cardinal *numParm)),
                SendDraftAction __P((Widget w, 
                                     XEvent *ev, 
                                     String *parm, 
                                     Cardinal *numParm)),
                CancelDraftAction __P((Widget w, 
                                       XEvent *ev, 
                                       String *parm, 
                                       Cardinal *numParm)),
                QuoteScStyleFmtAction __P((Widget w, 
                                           XEvent *ev, 
                                           String *parm, 
                                           Cardinal *numParm)),
                QuoteScStyleUnfmtAction __P((Widget w, 
                                             XEvent *ev, 
                                             String *parm, 
                                             Cardinal *numParm)),
                QuoteRnStyleAction __P((Widget w, 
                                        XEvent *ev, 
                                        String *parm, 
                                        Cardinal *numParm)),
                InsertSignatureAction __P((Widget w, 
                                           XEvent *ev, 
                                           String *parm, 
                                           Cardinal *numParm)),
                HighlightCurrentLineAction __P((Widget w, 
                                                XEvent *ev, 
                                                String *parm, 
                                                Cardinal *numParm)),
                PrevLineAction __P((Widget w, 
                                    XEvent *ev, 
                                    String *parm, 
                                    Cardinal *numParm)),
                NextLineAction __P((Widget w, 
                                    XEvent *ev, 
                                    String *parm, 
                                    Cardinal *numParm)),
                BeginningOfBufferAction __P((Widget w, 
                                             XEvent *ev, 
                                             String *parm, 
                                             Cardinal *numParm)),
                EndOfBufferAction __P((Widget w, 
                                       XEvent *ev, 
                                       String *parm, 
                                       Cardinal *numParm)),
                MenuButtonPopdownMenuAction __P((Widget w, 
                                                 XEvent *ev, 
                                                 String *parm, 
                                                 Cardinal *numParm)),
                PopupMenuIfMenuButtonAction __P((Widget w, 
                                                 XEvent *ev, 
                                                 String *parm, 
                                                 Cardinal *numParm));

static void
                GetResources __P((Widget toplevel)),
		CheckMailCallback __P((XtPointer client_data, 
                                       XtIntervalId *id));

QueryResources res;

static  XtAppContext          appContext;  

void
main(argc, argv)
     int             argc;
     char           *argv[];
{
  Widget                topLevel;
  SCREEN		*default_scn;
  XtIntervalId		checkTimer;

  static char    *fallbackResources[] = {
#include "Mumail.ad.h"
    NULL,
  };

  static XrmOptionDescRec optionList[] =  {
    {"-checktime", "checkTime", XrmoptionSepArg, NULL},
  };

  static XtActionsRec actionTable[] = {
    {"ClearCutBuffer", ClearCutBufferAction},
    {"IncCurLetterNumber", IncCurLetterNumberAction},
    {"DecrCurLetterNumber", DecrCurLetterNumberAction},

    {"BodyBoxNextPage", BodyBoxNextPageAction},
    {"BodyBoxPrevPage", BodyBoxPrevPageAction},
    {"BodyBoxNextLine", BodyBoxNextLineAction},
    {"BodyBoxEndOfPage", BodyBoxEndOfPageAction},

    {"CloseWindow", CloseWindowAction},
    {"IconifyWindow", IconifyWindowAction},
    {"HighlightCurrentLine", HighlightCurrentLineAction},

    {"OpenFolder", OpenFolderAction},
    {"SaveFolder", SaveFolderAction},
    {"CommitChanges", CommitChangesAction},
    {"FolderInfo", FolderInfoAction},
    {"QuickExit", QuickExitAction},
    {"Exit", ExitAction},

    {"SetCurLetterNumber", SetCurLetterNumberAction},
    {"DisplayLetterGeneral", DisplayLetterGeneralAction},
    {"RedisplayCurLetterPartial", RedisplayCurLetterPartialAction},
    {"RedisplayCurLetterWhole", RedisplayCurLetterWholeAction},

    {"TagUntagLetter", TagUntagLetterAction},
    {"RetagLetters", RetagLettersAction},
    {"DeleteLetter", DeleteLetterAction},
    {"UndeleteLetter", UndeleteLetterAction},
    {"ComposeLetter", ComposeLetterAction},
    {"ReplyToLetter", ReplyToLetterAction},
    {"ForwardLetter", ForwardLetterAction},
    {"ExternalComposeLetter", ExternalComposeLetterAction},
    {"CopyLetter", CopyLetterAction},
    {"RefileLetter", RefileLetterAction},
    {"LetterInfo", LetterInfoAction},

    {"SendDraft", SendDraftAction},
    {"CancelDraft", CancelDraftAction},
    {"QuoteScStyleFmt", QuoteScStyleFmtAction},
    {"QuoteScStyleUnfmt", QuoteScStyleUnfmtAction},
    {"QuoteRnStyle", QuoteRnStyleAction},
    {"InsertSignature", InsertSignatureAction},

    {"HighlightToEndOFLine", HighlightToEndOFLineAction},
    {"PrevLine", PrevLineAction},
    {"NextLine", NextLineAction},
    {"BeginningOfBuffer", BeginningOfBufferAction},
    {"EndOfBuffer", EndOfBufferAction},


    {"MenuButtonPopdownMenu", MenuButtonPopdownMenuAction},
    {"PopupMenuIfMenuButton", PopupMenuIfMenuButtonAction},
  };

  topLevel = XtAppInitialize(&appContext, "Mumail", optionList,
							 XtNumber(optionList), &argc, argv,
							 fallbackResources, NULL, 0);
  if (argc > 1)	{
	MuError(FmtString("Incorrect or incomplete argument: %s", argv[1])); 
	 exit(1);
  }
  MuNotice(FmtString("Mumail %s.%s is initializing..", VERSION, REVISION));  

  XtAppAddActions(appContext, actionTable, XtNumber(actionTable));
  XtOverrideTranslations(topLevel,
		       XtParseTranslationTable("<Message>WM_PROTOCOLS: QuickExit()"));

  GetResources(topLevel);


  default_scn = AddScreen(topLevel, FileInMailDir(INFOLDER_NAME));

  /* Read any outstanding mail this needs to be done after folder is
     open so we have a screen structure */ 
  if (IncorporateNewMailProc(default_scn) >= 0)
     /* Make sure the mail is visable */
     if (OpenFolder(default_scn, FileInMailDir(INFOLDER_NAME)) >= 0)
         SimpleMessage(default_scn, 
                       FmtString("New mail incorporated to folder %s", 
                                 INFOLDER_NAME));


  SetIconState(default_scn);
  checkTimer = XtAppAddTimeOut(appContext, res.checkTime*1000, 
			(XtTimerCallbackProc)CheckMailCallback, (XtPointer)default_scn);

  XtAppMainLoop(appContext);
}

static void CheckMailCallback(client_data, id)
    XtPointer          client_data; 
    XtIntervalId*      id;
{
SCREEN *scn = (SCREEN *)client_data;
SCREEN *tmp_scn;
LETTER *letter;
int i, have_mail;
XtIntervalId checkTimer;

/* Check each active screen for having INBOX open */
for(tmp_scn=FirstScreen(scn); tmp_scn; tmp_scn=NextScreen(tmp_scn))
	if (!(strcmp(tmp_scn->folder.name, INFOLDER_NAME)))
	   {
           if (AppendNewMailProc(tmp_scn) < 0)
              /* No new mail return */
              break;

           SimpleMessage(tmp_scn, 
                         FmtString("New mail incorporated to folder %s", 
                         INFOLDER_NAME));

           XBell(XtDisplay(scn->parentW),100);
           XBell(XtDisplay(scn->parentW),100);
           break;
           }


 /* Go ahead and update the icons states for all screens */
for(tmp_scn=FirstScreen(scn); tmp_scn; tmp_scn=NextScreen(tmp_scn))
   SetIconState(tmp_scn);
 checkTimer = XtAppAddTimeOut(appContext, res.checkTime*1000,
                        CheckMailCallback, (XtPointer)scn);


}

Widget
SetupTocW(parentW)
	 Widget parentW;
{
  Widget          frameW, widget;
  static          XawTextSelectType selectTypes[] = {XawselectLine,
													   XawselectNull};
  
#if USE_3D_FRAME
  frameW = 	XtVaCreateManagedWidget("tocFrame", xfwfFrameWidgetClass,
									parentW, NULL); 
#else
  frameW = parentW;
#endif

  widget = AddAsciiText("toc", frameW);
  XtVaSetValues(widget, XtNselectTypes, selectTypes, NULL);
  return widget;
}

Widget
SetupBodyW(parentW)
	 Widget parentW;
{
  Widget          widget, frameW;
  Widget          textSinkW;
  XFontStruct    *font;
  Dimension       width;

#if USE_3D_FRAME
  frameW = 	XtVaCreateManagedWidget("bodyFrame", xfwfFrameWidgetClass,
									parentW, NULL); 
#else
  frameW = parentW;
#endif

  widget = AddAsciiText("body", frameW);

  XtVaGetValues(widget, XtNfont, &font, XtNtextSink, 
				&textSinkW,	NULL);
  width = font->max_bounds.rbearing + font->min_bounds.lbearing;
  XtVaSetValues(widget, XtNwidth, 81 * width, NULL);
  XtVaSetValues(widget, XtNrightMargin, 10 * width, NULL); 
  return widget;

/*  XtVaSetValues(widget, XtNwidth, 81 * width, XtNleftMargin, 
				width, XtNrightMargin, 10 * width, NULL); 

  XtVaSetValues(textSinkW, XtNwidth, (Dimension)486, 
				XtNleftMargin, 
				(Dimension) 6 , XtNrightMargin,  (Dimension) 60,
				NULL); 
  printf("-%d-\n", (int)width);*/
}

void
SetupDialogW(scn, parentW)
	 SCREEN          *scn;
	 Widget          parentW;
{
  Widget          dialogW, frameW;

#if USE_3D_FRAME
  frameW = 	XtVaCreateManagedWidget("dialogFrame", xfwfFrameWidgetClass,
									parentW, NULL); 
#else
  frameW = parentW;
#endif

  dialogW = AddPaned("dialogW", frameW);

  scn->dialog.yesW = AddButton("yesW", dialogW, NULL, NULL);
  scn->dialog.cancelW = AddButton("cancelW", dialogW, NULL, NULL);
  scn->dialog.valueW = AddAsciiText("valueW", dialogW);

  XtVaSetValues(scn->dialog.yesW, XtNmappedWhenManaged, False, NULL);
  XtVaSetValues(scn->dialog.cancelW, XtNmappedWhenManaged, False, NULL);

  scn->dialog.mode = DIALOG_INACTIVE;
}

static Pixmap mail_pixmap, nomail_pixmap;
static Pixmap mail_mask= (Pixmap)NULL, nomail_mask= (Pixmap)NULL;
static int inited=0;
static Pixel bpix;
static Bool shape;
static XpmAttributes mail_atts,nomail_atts;
#include "mail.xpm"
#include "nomail.xpm"

void
SetIcon(parentW, mail)
     Widget          parentW;
     int             mail;
{
Window iconW;

/* Create the pixmaps is needed */
if (!inited)
   {
   XColor color, junk;
   int d1,d2,d3;

   if (XAllocNamedColor(XtDisplay(parentW), 
                        DefaultColormapOfScreen(XtScreen(parentW)), 
                        "black", &color, &junk))
      bpix = color.pixel;
   else
      bpix = XBlackPixelOfScreen(XtScreen(parentW));

   if (res.mailIcon)
      XpmReadFileToPixmap(XtDisplay(parentW), 
                          RootWindowOfScreen(XtScreen(parentW)), 
                          res.mailIcon, &mail_pixmap, &mail_mask, 
                           &mail_atts);
   else
      XpmCreatePixmapFromData(XtDisplay(parentW), 
                           RootWindowOfScreen(XtScreen(parentW)), 
                           mail_xpm, &mail_pixmap, &mail_mask, 
                           &mail_atts);

   if (res.mailIcon)
      XpmReadFileToPixmap(XtDisplay(parentW), 
                          RootWindowOfScreen(XtScreen(parentW)), 
                          res.nomailIcon, &nomail_pixmap, &nomail_mask, 
                           &nomail_atts);
   else
      XpmCreatePixmapFromData(XtDisplay(parentW), 
                           RootWindowOfScreen(XtScreen(parentW)), 
                           nomail_xpm, &nomail_pixmap, &nomail_mask, 
			   &nomail_atts);

   shape = XQueryExtension(XtDisplay(parentW),
                           "SHAPE", &d1, &d2, &d3);
   }

/* Check for an existing icon window */ 
iconW = (Window)NULL;
XtVaGetValues(parentW, XtNiconWindow, &iconW, NULL);

if (iconW == (Window)NULL)
   {
   iconW = XCreateSimpleWindow(XtDisplay(parentW), 
                               RootWindowOfScreen(XtScreen(parentW)), 
                               0, 0,
                               mail_atts.width, 
                               mail_atts.height, 
                               1, bpix, bpix);
   XtVaSetValues(parentW, XtNiconWindow, iconW, NULL);
   }

XClearWindow(XtDisplay(parentW),iconW);
XSetWindowBackgroundPixmap(XtDisplay(parentW), iconW, 
			(mail ? mail_pixmap : nomail_pixmap));

if (shape && (mail ? mail_mask : nomail_mask))
   XShapeCombineMask(XtDisplay(parentW), iconW, ShapeBounding, 0, 0,
		     (mail ? mail_mask : nomail_mask), ShapeSet);


XFlush(XtDisplay(parentW));
}

void SetIconState(scn)
     SCREEN *scn;
{
int have_mail, i;
Letter *letter;

   have_mail=False;
   for (i=0; (letter = scn->letterList[i]); i++)
       if ( (letter->status & 
             (LETTER_READ | LETTER_REPLIED | LETTER_DELETED)) 
             == 0) 
          {
          have_mail=True;
          break;
          }
   SetIcon(scn->parentW,have_mail);

} 
void
DisplayLogo(scn)
	 SCREEN   *scn;
{
#include "Mumail.logo.h"

  char        versionInfo[BUF256];
  String      logoBuffer; 

  sprintf(versionInfo, "%5sVersion %s rev. %s %s-%s %s@%s %s %s\n\n\n%12s%s", 
		  "", VERSION, REVISION, COMPILE_HOSTTYPE, COMPILE_OSNAME, 
		  COMPILE_BY, COMPILE_HOST, COMPILE_DATE, COMPILE_TIME, "",
		  "Comments, suggestions, and bug fixes are welcome");
  
  logoBuffer = XtMalloc(strlen(logo)+strlen(versionInfo)+1);
  sprintf(logoBuffer, "%s%s", logo, versionInfo);

  DisplayBufferInBodyBox(scn, logoBuffer);
  XtFree(logoBuffer);
}

/* ARGSUSED */
void
DisplayLogoCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  DisplayLogo((SCREEN*)clientData);
}

String
XMailerMessage()
{
  /* Instead of allocating new space */
  String buffer = FmtString(""); 

  sprintf(buffer, "X-Mailer: Mumail [version %s.%s %s-%s]", 
		  VERSION, REVISION, COMPILE_HOSTTYPE, COMPILE_OSNAME);
  return buffer;
}



int
FigureEnumeration(var, val, num, enumS, enumV)
	 XtPointer          *var;
	 String             val;
     int                num;
	 String             *enumS;
	 XtPointer          *enumV;
{
  int          n;

  for (n = 0; n < num; n++)
	if (CaseNStrSame(val, enumS[n], strlen(enumS[n])))
	  {*var = enumV[n]; return 0;}
  return -1;
}

#define MAX_RES_ENUM 10


/*---------------------------------------------------------------------------+
| GetResources - gets the application resources.
+---------------------------------------------------------------------------*/

static void
GetResources(topLevel)
	 Widget          topLevel;
{
  String             enumS[MAX_RES_ENUM];
  XtPointer          enumV[MAX_RES_ENUM], retVal;
  int                n;

#define offset(field) XtOffsetOf(QueryResources, field)
  static XtResource resources[] = {
    {"printCommand", "printCommand", XtRString, sizeof(String),
	   offset(printCommand), XtRString, (XtPointer)"lpr"},
    {"externalEditor", "ExternalEditor", XtRString, sizeof(String),
	   offset(externalEditor), XtRString, (XtPointer)"emacs"},
    {"signatureFile", "SignatureFile", XtRString, sizeof(String),
	   offset(signatureFile), XtRString, (XtPointer)".signature"},
    {"checkTime", "CheckTime", XtRInt, sizeof(int),
	   offset(checkTime), XtRString, (XtPointer)"300"},
    {"mailIcon", "MailIcon", XtRString, sizeof(String),
	   offset(mailIcon), XtRImmediate, (XtPointer)NULL},
    {"nomailIcon", "NomailIcon", XtRString, sizeof(String),
	   offset(nomailIcon), XtRImmediate, (XtPointer)NULL},
    {"contentInToc", "ContentInToc", XtRBoolean, sizeof(Boolean), 
	   offset(contentInToc), XtRImmediate, (XtPointer)False},
    {"folderBackup", "FolderBackup", XtRBoolean, sizeof(Boolean), 
	   offset(folderBackup), XtRImmediate, (XtPointer)True},
  },

  citeResources[] = {
    {"fillColumn", "FillColumn", XtRInt, sizeof(int),
	   offset(quoteFillColumn), XtRImmediate, (XtPointer)70},
    {"indentString", "IndentString", XtRString, sizeof(String),
	   offset(quoteIndentString), XtRString, (XtPointer)"\t"},
    {"nestedAttribFmt", "NestedAttribFmt", XtRString, sizeof(String),
	   offset(quoteNestedAttribFmt), XtRString, 
	   (XtPointer)"\n>>>>> %s wrote:\n>\n"},
    {"nonNestedAttribFmt", "NonNestedAttribFmt", XtRString, 
	   sizeof(String), offset(quoteNonNestedAttribFmt), XtRString, 
	   (XtPointer)"\n>>>>> %s == %s wrote:\n\n"},
  },

  mailAgentResources[] = {
    {"passAddress", "PassAddress", XtRBoolean, sizeof(Boolean), 
	   offset(mailAgentPassAddress), XtRImmediate, (XtPointer)False},
    {"program", "Program", XtRString, sizeof(String),
	   offset(mailAgentProgram), XtRString, (XtPointer)"/usr/lib/sendmail"},
    {"arguments", "Arguments", XtRString, sizeof(String),
	   offset(mailAgentArgs), XtRString, (XtPointer)"-bm -oi -oem -t"},
  },

  mimeResources[] = {
    {"agentCommand", "AgentCommand", XtRString, sizeof(String), 
	   offset(mimeCommand), XtRString, 
	   (XtPointer)"metamail -d -r -x -m Mumail"},
    {"invokeAgent", "InvokeAgent", XtRString, sizeof(String),
	   offset(invokeMimeS), XtRString, (XtPointer)"ask"},
    {"addHeaders", "AddHeaders", XtRBoolean, sizeof(Boolean),
	   offset(addMimeHeaders), XtRImmediate, (XtPointer)True},
    {"defaultContentType", "DefaultContentType", XtRString, sizeof(String),
	   offset(defaultContentType), XtRString, (XtPointer)"text/plain"},
    {"defaultCharSet", "DefaultCharSet", XtRString, sizeof(String),
	   offset(defaultCharSet), XtRString, (XtPointer)"US-ASCII"},
    {"defaultTransferEncoding", "DefaultTransferEncoding", XtRString, 
	   sizeof(String), offset(defaultTransferEncoding), XtRString, 
	   (XtPointer)"7BIT"},
    {"multipartBoundary", "MultipartBoundary", XtRString, sizeof(String),
	   offset(mimeBoundary), XtRString, (XtPointer)"####"},
  },

  sortResources[] = {
    {"when", "When", XtRString, sizeof(String), 
	   offset(sortWhenS), XtRString, (XtPointer)"burst open"},
    {"majorKey", "MajorKey", XtRString, sizeof(String),
	   offset(majorSortKeyS), XtRString, (XtPointer)"date"},
    {"minorKey", "MinorKey", XtRString, sizeof(String),
	   offset(minorSortKeyS), XtRString, (XtPointer)"subject"},
    {"descending", "descending", XtRBoolean, sizeof(Boolean), 
	   offset(sortDescending), XtRImmediate, (XtPointer)False},
  };
#undef offset

  XtGetApplicationResources(topLevel, (XtPointer)&res, resources,
							XtNumber(resources), NULL, 0);

  XtGetSubresources(topLevel, (XtPointer)&res, "cite", "Cite", 
					citeResources, XtNumber(citeResources), NULL, 0);
  XtGetSubresources(topLevel, (XtPointer)&res, "mailAgent", "MailAgent", 
					mailAgentResources, XtNumber(mailAgentResources), NULL, 0);
  XtGetSubresources(topLevel, (XtPointer)&res, "mime", "Mime", 
					mimeResources, XtNumber(mimeResources), NULL, 0);
  XtGetSubresources(topLevel, (XtPointer)&res, "sort", "Sort", 
					sortResources, XtNumber(sortResources), NULL, 0);

  n = 0;
  enumS[n] = "never"; enumV[n] = (XtPointer)MIME_INVOKE_NEVER; n++;
  enumS[n] = "always"; enumV[n] = (XtPointer)MIME_INVOKE_ALWAYS; n++;
  enumS[n] = "ask"; enumV[n] = (XtPointer)MIME_INVOKE_ASK; n++;
  if (FigureEnumeration(&retVal, (XtPointer)StripStringB(res.invokeMimeS), 
						n, enumS, enumV) < 0)
	res.invokeMime = MIME_INVOKE_ASK;
  else res.invokeMime = (int)(long)retVal;


  res.sortWhen = 0;
  if (CaseStrstr(res.sortWhenS, "open")) res.sortWhen |= SORT_ON_OPEN;
  if (CaseStrstr(res.sortWhenS, "save")) res.sortWhen |= SORT_ON_SAVE;
  if (CaseStrstr(res.sortWhenS, "burst")) res.sortWhen |= SORT_ON_BURST;
  if (CaseStrstr(res.sortWhenS, "inc")) res.sortWhen |= SORT_ON_INC;
  if (CaseStrstr(res.sortWhenS, "commit")) res.sortWhen |= SORT_ON_COMMIT;

  n = 0;
  enumS[n] = "date"; enumV[n] = (XtPointer)CompareLettersByDateProc; n++;
  enumS[n] = "subject"; enumV[n] = (XtPointer)CompareLettersBySubjectProc; 
  n++;
  enumS[n] = "name"; enumV[n] = (XtPointer)CompareLettersByNameProc; n++;
  if (FigureEnumeration(&retVal, (XtPointer)StripStringB(res.majorSortKeyS), 
						n, enumS, enumV) < 0)
	res.majorSortProc = CompareLettersByDateProc;
  else res.majorSortProc = (int(*)())retVal;

  if (FigureEnumeration(&retVal, (XtPointer)StripStringB(res.minorSortKeyS), 
						n, enumS, enumV) < 0)
	res.majorSortProc = CompareLettersBySubjectProc;
  else res.minorSortProc = (int(*)())retVal;
}
