#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MuAlert.c,v 1.2 1994/03/31 17:57:50 dwb Exp $";
#endif


/*
 * $Log: MuAlert.c,v $
 * Revision 1.2  1994/03/31  17:57:50  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:53:06  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MuAlert.c --- Alert popup
 * Author          : Muhammad M. Saggaf
 * Created On      : June 1993
 * Last Modified By: system admin
 * Last Modified On: Mon Jun 28 17:04:41 1993
 * Update Count    : 43
 * Status          : Mostly OK, needs some cleaning up
 */

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#if USE_3D_FRAME
#include "Xfwf/Frame.h"
#endif
#include <ctype.h>				/* for isspace */

#include "MuWin.h"
#include "MuGeneric.h"

#define BUTTON_DELIMITER "|"

int          alertReturnValue;

/* ARGSUSED */
void
AlertEndCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  alertReturnValue = (int)(long)clientData;
}

/* ARGSUSED */
int
Alert(type, parentW, message, buttons)
	 int             type;
	 Widget          parentW;
	 String          message,
	                 buttons;
{
  Widget                 popupW, frameW, 
                         hPanedW, vPanedW,
                         boxW, 
                         labelW, buttonW;
  static String          buttonS;
  String                 title, curPtr;
  char                   c;
  int                    i;

  popupW = XtVaCreatePopupShell("alert",
								transientShellWidgetClass, parentW,
								XtNtransientFor, GetShell(parentW),
								XtNtitle, "Alert",
								NULL); 

#if 0 /*USE_3D_FRAME*/
  frameW = 	XtVaCreateManagedWidget("alertFrame", xfwfFrameWidgetClass,
									popupW, NULL); 
#else
  frameW = popupW;
#endif
	
  hPanedW = AddPaned("hPaned", frameW);
  vPanedW = AddPaned("vPaned", hPanedW);

  labelW = AddLabel("message", vPanedW);
  XtVaSetValues(labelW, 
				XtNshowGrip, False, 
				XtNlabel, message, 
				XtNjustify, XtJustifyCenter,
				NULL);

  boxW = AddBox("box", vPanedW);
  XtVaSetValues(boxW, 
				XtNorientation, XtorientHorizontal,
				NULL);

  if (buttons == NULL) {
	buttonW = AddButton("Ok", boxW, AlertEndCallback, (XtPointer)(long)1);
	XtVaSetValues(buttonW, 
				  XtNlabel, "Ok", 
				  NULL);
  }
  else {
	if (buttonS) XtFree(buttonS);
	buttonS = XtNewString(buttons);
	for (i = 1; 
		 (title = strtok(i == 1 ? buttonS : NULL, BUTTON_DELIMITER));
		 i++) {

	  title = StripStringA(title);
	  for (curPtr = title; *curPtr && !isspace(*curPtr); curPtr++);
	  c = *curPtr;
	  *curPtr = CNULL;

	  buttonW = AddButton(title, boxW, AlertEndCallback, (XtPointer)(long)i); 

	  *curPtr = c;
	  XtVaSetValues(buttonW, 
					XtNlabel, StripStringA(title), 
					NULL);
	}
  }

  PopupCentered(popupW, parentW);

  alertReturnValue = 0;
  while(alertReturnValue == 0) 
	XtAppProcessEvent(XtWidgetToApplicationContext(parentW), XtIMAll);

  DestroyShell(popupW);
  return alertReturnValue;
} 
  
