#define DEFAULTMBOX "mbox"

/* set this to the max number of messages you can read in at once */

#define MAXMSG 4096

/* constants for constructing the header summary lines
   make sure if you edit them that they stay consistent! */

#define HDR_ADDR      24      /* length of address part */
#define HDR_SUBJ      59      /* length of subject part */
#define HDR_SUBSTART  50      /* start of subject part */
#define HDR_MBOX      16      /* last nn chars of mbox name */
#define HDR_DATE      24      /* length of date part */
#define HDR_FMT "%-24s %-24s %s"  /* format string for headers */
#define HDR_MBOX_FMT "%-16s " /* should match HDR_MBOX! */
#define HDR_TOT_FMT "%-110s"   /* to print whole header */
#define HDR_SUBJ_FMT "%-59s"   /* should match subj length */

struct message {
  char *begin;             /* beginning of message */
  char *end;               /* beginning of next message */
  char *hdr;               /* string containing abbreviated header */
  unsigned int date;       /* hopefully somewhat correct */
  int hits;                /* hits found in last search */
  int sequence;            /* original order of messages */
  int mbox;                /* index to list of mail files loaded */
  int deleted;             /* not really deleted, but hidden */
};

struct mbox {
  char *filename;
  char *buf;               /* where mmap'ed to, for freeing */
};

/* constants for headers() function or sort keys */

#define DATE     1          /* in unix time format */
#define HEADER   2          /* summary header user, date, subject */
#define HITS     4          /* hits from last search */
#define SEQUENCE 8          /* message sequence number */
#define SUBJECT  16         /* subject (fixed position in header */
#define NONZERO_HITS 32     /* skip messages with no hits */
#define MBOX     64         /* last 16 chars of mbox name */
#define NO_NEWLINE 128      /* don't newline at the end */

#define CHECK_LOADED if (!number) { puts("No file"); break; }

#define EOM_STRING "----- END DNE -----\n"
