/*
 * This file is part of the FEddi package
 *
 * Personal use allowed under the terms of the
 *
 *              GNU GENERAL PUBLIC LICENSE Version 2
 *              (see LICENSE for the complete text)
 *
 *-------------------------------------------------------------------
 *
 *    ENTER AT YOUR OWN RISK !!
 *
 * This source is without any documentation and can drive you mad.
 * In case of sudden epileptic seizures please call your doctor.
 *
 */

#ifndef _INOUT_H
#define _INOUT_H

#include "structs.h"

void outputMsg(FILE *f, int num, char *area,
		MsgHdrType *hdr, int textl, LineListType **text,
		int kludgel, LineListType **kludges);
int inputMsg(FILE *f, int COLS, int *save, char *area,
		MsgHdrType *hdr,
		int *lines, LineListType **text,
		int *klines, LineListType **kludges,
		int *slines, LineListType **status);
int pipeMsg(int pid, FILE *rp, FILE *wp,
		int num, int COLS, int *save, char *area,
		MsgHdrType *hdr, int *textl, LineListType **text,
		int *kludgel, LineListType **kludges,
		int *statl, LineListType **status);
void loadTextOfMsg(int MAXCOLS, MsgHdrType *mh,
		int *MsgLines, LineListType **MsgTxt,
		int *KludgeLines, LineListType **Kludges,
		int *DispKludgeLines, LineListType **DispKludges);
void killTextOfMsg(int *MsgLines, LineListType **MsgTxt,
		int *KludgeLines, LineListType **Kludges,
		int *DispKludgeLines, LineListType **DispKludges);
void initquote();
int IsQuote(char *);
int GetQuotePos(char *);
char *GetQuote(char *);

#endif
