/*
 * This file is part of the FEddi package
 *
 * Personal use allowed under the terms of the
 *
 *              GNU GENERAL PUBLIC LICENSE Version 2
 *              (see LICENSE for the complete text)
 *
 *-------------------------------------------------------------------
 *
 *    ENTER AT YOUR OWN RISK !!
 *
 * This source is without any documentation and can drive you mad.
 * In case of sudden epileptic seizures please call your doctor.
 *
 */

#ifndef _PROC_H
#define _PROC_H

#include <linux/limits.h>
#include <linux/dirent.h>
#include "structs.h"

#include "config.h"

#ifdef _PROC
#define E

const char VERSION[]="0.9pl4";
const byte VERpl=0, MBVERpl=0;
const byte VERlo=9, MBVERlo=9;
const byte VERhi=4, MBVERhi=0;
const byte PCODE[6]={0xFE, 0xDD, 0x10, 0, 9, 0};

const char StandardOrig[]="FEddi (C)1993-95 by Oliver Graf";

char BasePath[PATH_MAX]="", OutboundPath[PATH_MAX]="", CopyPath[PATH_MAX]="";
char LogFile[PATH_MAX]="", NodelistPath[PATH_MAX]="", InboundPath[PATH_MAX]="";
char Packer[PATH_MAX]="", Editor[PATH_MAX]="", ConfigName[PATH_MAX]="";
char UtilityPath[PATH_MAX]="", Unpacker[PATH_MAX]="unpack";
char ExportMsg[PATH_MAX]="exportmsg";
char ImportText[PATH_MAX]="importtext";
char PrintMsg[PATH_MAX]="printmsg";

int QUIET=0, COLON=0;

#else

extern const char VERSION[];
extern const int VERpl, VERlo, VERhi;
extern const int MBVERpl, MBVERlo, MBVERhi;
extern const byte PCODE[6];

extern const char StandardOrig[];

extern char BasePath[PATH_MAX], OutboundPath[PATH_MAX], CopyPath[PATH_MAX];
extern char LogFile[PATH_MAX], NodelistPath[PATH_MAX], InboundPath[PATH_MAX];
extern char Packer[PATH_MAX], Editor[PATH_MAX], ConfigName[PATH_MAX];
extern char UtilityPath[PATH_MAX], Unpacker[PATH_MAX];
extern char ExportMsg[PATH_MAX];
extern char ImportText[PATH_MAX];
extern char PrintMsg[PATH_MAX];

extern int QUIET, COLON;

#define E extern
#endif

E dword TotalMsgs;
E MsgDataType MsgData;
E FILE *mtf, *mhf;

E int WordWrap, Origlines, BeepOn, AutoDelEmpty, Aliases;
E int BaseOrig, BaseAlias, Origchoose;
E int KeepPkt, KeepNl, KeepBackups, ReplySubject;
E int QuoteLength, ListMode, AutoNextFolder, SkipDeleted;
E UserProfileType Profile;
E UserAkaType *Aka;
E LineListType *OrigLine;
E char **Alias;
E char ProgName[20], HomePath[PATH_MAX];
E int ShowAllAddr, MaxMsgLength, AskForOrigName, Mailer, ConvertChars;
E int ClearMarks;
E word StandardFlags;

extern long logpos;

int loadrc(int);
dword openarea(char *an, char *path);
dword openareasloppy(char *an);
int closearea();
MsgDataType getmsgdata(char *an, char *path);
void getsizes(char *an, char *path, dword *tm, dword *tr);
void newarea(char *an, UserAkaType *aka);
dword MsgId(char *, int);
void DateTime(char *s);
int Str2Addr(char *s, Addr4dType *a);
int strtoadr(char *s, Addr4dType *adr);
int AddrMatch(Addr4dType *a, MsgHdrType *mh);
void MatchAddr(MsgHdrType *mh, int nm);
bigint getkey(char *);
void upperstr(char *);
void savemsgdata();
void loadmsghdr(MsgHdrType **);
void savemsghdr(MsgHdrType **);
int unpack(int, char *, int);
char *strcasestr(char *, char *);
void backslash(char *);
void lowerstr(char *);
int strloc(char, char *);
int extendhome(char *);

void Log(char *template, ...);
void EndLog();
void savelogpos();
int logposchanged();

void loadorig(char *);
void loadalias(char *);

int LOCKBase(int);
void UNLOCKBase();

int findfile(char *s, char *p);

void printERR(char *template, ...);

int pipecall(char *command, char **args, FILE **readpipe, FILE **writepipe);
int canread(FILE *);
int canwrite(FILE *);

void freedirentries(struct dirent ***ents, int num);

#define mksl(s) if (!s[0] || s[strlen(s)-1]!='/') strcat(s,"/")
#define CUTline "--- FEddi %s via %s"

#endif
