/*
 * This file is part of the FEddi package
 *
 * Personal use allowed under the terms of the
 *
 *              GNU GENERAL PUBLIC LICENSE Version 2
 *              (see LICENSE for the complete text)
 *
 *-------------------------------------------------------------------
 *
 *    ENTER AT YOUR OWN RISK !!
 *
 * This source is without any documentation and can drive you mad.
 * In case of sudden epileptic seizures please call your doctor.
 *
 */

#ifndef STRUCTS
#define STRUCTS

typedef unsigned short word;
typedef unsigned char  byte;
typedef unsigned int   dword;
typedef long long int  bigint;

typedef struct
{
	word	Mother;
	word	prevBrother, nextBrother;
	word	Child;
	word	prevSubject, nextSubject;
	word	Personal:1;
	word	Deleted:1;
	word	TruncSent:1;
	word	DeleteSent:1;
	word	Direct:1;
	word	Marked:1;
	word	New:1;
	word	Protected:1;
	word	NewPersonal:1;
	dword	StartRec;
	byte	NumRecs;
	short	DestZone;
	short	DestNet;
	short	DestNode;
	short	DestPoint;
	short	OrigZone;
	short	OrigNet;
	short	OrigNode;
	short	OrigPoint;
	word	Attribute;
	char	DateTime[20];
	char	Recvdt[20];
	char	WhoTo[36];
	char	WhoFrom[36];
	char	Subj[72];
} MsgHdrType;

#define MsgHdrSize sizeof(MsgHdrType) 

typedef struct
{
	byte	ID[3];
	byte	VMAJOR;
	byte	VMINOR;
	byte	VPATCH;
	word	LastRead;
	word	Deleted;
	word	New;
	word	NewPersonal;
	word	Marked;
	int	CharSet;
	word	ReadOnly:1;
	word	NetMail:1;
	word	Linked:1;
	short	RouteZone;
	short	RouteNet;
	short	RouteNode;
	char	Owner[36];
	char	RealName[40];
} MsgDataType;

typedef struct
{
	byte	ID[3];
	byte	VMAJOR;
	byte	VMINOR;
	byte	VPATCH;
	word	LastRead;
	word	Deleted;
	word	New;
	word	NewPersonal;
	word	Marked;
	int	CharSet;
	word	ReadOnly:1;
	word	NetMail:1;
	word	Linked:1;
	short	RouteZone;
	short	RouteNet;
	short	RouteNode;
} MsgData07Type;

typedef struct
{
	word	LastRead;
	word	Deleted;
	word	New;
	word	NewPersonal;
	word	ReadOnly:1;
	word	NetMail:1;
	word	Linked:1;
	short	RouteZone;
	short	RouteNet;
	short	RouteNode;
	char	Tag[70];
	int	CharSet;
} OldMsgDataType;

#define MsgDataSize sizeof(MsgDataType)
#define MsgData07Size sizeof(MsgData07Type)
#define OldMsgDataSize sizeof(OldMsgDataType)

/*

MsgTxt ist ein einziger, langer, NULLterminierter String

Nun folgt Pkt Format
*/

typedef struct
{
	short	OrigNode;
	short	DestNode;
	short	Year;
	short	Month;
	short	Day;
	short	Hour;
	short	Minute;
	short	Second;
	short	Baud;
	short	Version;
	short	OrigNet;
	short	DestNet;
	byte	ProductCodeLo;
	byte	SerialNumMaj;
	char	Password[8];
	short	qOrigZone;
	short	qDestZone;
	byte	filler[3];
	byte	Use4dAddressing;
	byte	ProductCodeHi;
	byte	SerialNumMin;
	word	CapWord;
	short	OrigZone;
	short	DestZone;
	short	OrigPoint;
	short	DestPoint;
	short	ProductData;
	short	ProductData2;
} PktHdrType;

#define PktHdrSize sizeof(PktHdrType)

typedef struct
{
	short	Version;
	short	OrigNode;
	short	DestNode;
	short	OrigNet;
	short	DestNet;
	word	Attribute;
	short	Cost;
} PktMsgHdrType;

#define PktMsgHdrSize sizeof(PktMsgHdrType)

/*
After this:

toUserName	(NULL terminated) max 36
fromUserName	(NULL terminated) max 36
subject		(NULL terminated) max 72
text			(NULL terminated) nomax

text is:

AREA:[AreaName]0x0d
0x01[Spcl]0x0d
...
0x01[Spcl]0x0d
Text
--- [ProductName]
* Origin : Origin (OrigNode/Point)
SEEN-BY
...
SEEN-BY
0x00

*/

typedef struct
{
	char 	*line;
	int 	Quote;
	int		CR;
	int		CutOrigin;
} LineListType;

#define LineListSize sizeof(LineListType)

typedef struct tagAddr4dType
{
	struct tagAddr4dType *next;
	short 	Zone;
	short 	Net;
	short 	Node;
	short 	Point;
} Addr4dType;

#define Addr4dSize sizeof(Addr4dType)

typedef struct tagUserAkaType
{
	struct tagUserAkaType *next;
	short 	UserZone;
	short 	UserNet;
	short 	UserNode;
	short	UserPoint;
	char	*NetName;
	char	Password[9];
	char	Outbound[80];
	Addr4dType *Route;
} UserAkaType;

#define UserAkaSize sizeof(UserAkaType)

typedef struct
{
	char 	*UserLogin;
	char 	*UserName;
	UserAkaType *Aka;
} UserProfileType;

#define UserProfileSize sizeof(UserProfileType)

typedef struct
{
	byte	unread:1;
	byte	marked:1;
	word	Personal;
	word	Marked;
	char	name[40];
	char	*path;
	int	num;
} FolderType;

#define FolderSize sizeof(FolderType)

typedef struct
{
	bigint key;
	int pos;
	int next;
} KeyEntryType;

typedef struct
{
	byte num;
	int next0;
	KeyEntryType entry[4];
} KeyIndexType;

#define KeyIndexSize sizeof(KeyIndexType)

typedef struct
{
	int pos;
	int next;
} StrEntryType;

typedef struct
{
	byte num;
	int next0;
	StrEntryType entry[4];
} StrIndexType;

#define StrIndexSize sizeof(StrIndexType)

typedef struct
{
	byte Type;
	Addr4dType ad;
	char *Box;
	char *Pos;
	char *Sysop;
	char *Phone;
	int Speed;
	char *Flags;
} NLentryType;

#define NLentrySize sizeof(NLentryType)

typedef struct
{
	int PID;
	char Prog[20];
	char Date[20];
	char Host[400];
} LOCKType;

#define LOCKSize sizeof(LOCKType)

typedef struct
{
	char Label[20];
	int numNames;
	char **Names;
	Addr4dType *Addr;
	char **Subj;
	word *Attrib;
} GroupType;

#define GroupSize sizeof(GroupType)

#endif
