#:ts=8
#
# $Id: config.make,v 3.9.2.0 1995/06/12 17:11:12 mj Exp $
#
# FIDOGATE Makefile configuration
#

# OS2 = OS/2 with EMX GCC

# OS2: comment out
SHELL		= /bin/sh

# Directories
BINDIR		= /usr/local/bin
LIBDIR		= /usr/local/lib/fidonet
INFODIR		= /usr/local/info
SPOOLDIR	= /var/spool/fidonet
LOGDIR		= /var/adm/fidonet

OUTBOUND	= /var/spool/bt
INBOUND		= /var/spool/bt/in
PINBOUND	= /var/spool/bt/pin
UUINBOUND	= /var/spool/bt/uuin

# perl binary
PERL		= /usr/local/bin/perl

# owner / group
OWNER		= news
GROUP		= news

# install permissions
PERM_PROG	= 755
PERM_DATA	= 644
PERM_SETUID	= 4755
PERM_DIR	= 755

# C compiler / flags
CC		= gcc
#YACC		= yacc					# Use yacc, not bison
YACC		= bison -y
AR		= ar
#RANLIB		= @echo >/dev/null			# No ranlib
RANLIB		= ranlib
#RANLIB		= ar s					# OS2

#DEBUG		= -O2
DEBUG		= -g

#CFLAGS		= $(DEBUG) -Wall -posix -DISC		# ISC 3.x
#CFLAGS		= $(DEBUG) -Wall -DOS2			# OS2
CFLAGS		= $(DEBUG) -Wall

#LFLAGS		= -Zexe $(DEBUG) -L.			# OS2
LFLAGS		= $(DEBUG) -L.

#LIBS		= -lfidogate -linet -lPW -lcposix	# ISC 3.x
LIBS		= -lfidogate

# installation program
# ISC 3.x: use bsdinst
INSTALL_PROG	= install -g $(GROUP) -o $(OWNER) -m $(PERM_PROG)
INSTALL_DATA	= install -g $(GROUP) -o $(OWNER) -m $(PERM_DATA)
INSTALL_SETUID	= install -g $(GROUP) -o $(OWNER) -m $(PERM_SETUID)
INSTALL_DIR	= install -g $(GROUP) -o $(OWNER) -m $(PERM_DIR) -d

# library name
#LIB		= fidogate.a			# OS2
LIB		= libfidogate.a
