/* compat.c -- Missing functions replacements and others.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "tua.h"

#if HAVE_STDLIB_H
#include <stdlib.h>
#else
extern PTR EXFUN (malloc, (size_t size));
extern void EXFUN (free, (PTR ptr));
#endif
     
PTR
DEFUN (xmalloc, (size),
       size_t size)
{
  PTR ptr = malloc (size);

  if (ptr == 0)
    {
      fputs ("Out of memory!\n", stderr);
      exit (1);
    }
  return ptr;
}

void
DEFUN (xfree, (ptr),
       PTR ptr)
{
  if (ptr)
    free (ptr);
}

char *
DEFUN (savestring, (string),
       CONST char *string)
{
  char *tmp = (char *) xmalloc (strlen (string) + 1);

  return strcpy (tmp, string);
}

#if !HAVE_GETHOSTNAME

/*
 * From Cnews as of 1 Jan 91
 *
 * Uglix gethostname simulation
 */

#include <sys/types.h>
#include <sys/utsname.h>

#define min(a, b) ((a) < (b)? (a): (b))

int
DEFUN (gethostname, (buf, size),
       char *buf AND
       int size)
{
  struct utsname ugnm;
  char *strncpy ();

  if (uname (&ugnm) < 0)
    return -1;
  (void) strncpy (buf, ugnm.nodename, min (sizeof ugnm.nodename, size));
  return 0;
}

#endif /* !HAVE_GETHOSTNAME */

#if !HAVE_GETDOMAINNAME

int
DEFUN (getdomainname, (buf, size),
       char * buf AND int size)
{
  strcpy (buf, NET_DOMAIN);
  return 0;
}

#endif /* !HAVE_GETDOMAINNAME */

#if !HAVE_STRCASECMP

/* Thanx again Jan! */

#include <ctype.h>

int
DEFUN (strcasecmp, (s1, s2),
       CONST char * s1 AND CONST char * s2)
{
  char b1, b2;

  while ((b1 = *s1++) != '\0')
    {
      b2 = *s2++;
      if (b2 == '\0')
        return 1;
      if (b1 != b2)
        {
          if (isupper (b1))
            b1 = tolower (b1);
          if (isupper (b2))
            b2 = tolower (b2);
          if (b1 != b2)
            return b1 - b2;
        }
    }
  if (*s2 == '\0')
    return 0;
  else
    return -1;
}

#endif /* !HAVE_STRCASECMP */

/*
 * int strbegcmp (const char * s1, const char * s2)
 *
 * Returns non zero if the strings are different. Otherwise returns 0 if
 * they are equal or one is a prefix substring of the other
 */
int
DEFUN (strbegcmp, (s1, s2),
       CONST char * s1 AND CONST char * s2)
{
  while (*s1 && *s2)
    if (*s1 != *s2)
      return *s1 - *s2;
    else
      s1++, s2++;
  return 0;
}


/* WARNING!! THIS FUNCTION DO NOT CHECK FOR OVERFLOW
 * on double to int casts. TUA does not use big float
 * numbers, so this should be safe */

#if !HAVE_RINT
double
DEFUN (rint, (x),
       double x)
{
  double rinted = (double) ((int) (x+0.5));

  return rinted;
}
#endif /* !HAVE_RINT */

#if !HAVE_MODF
double
DEFUN (modf, (value, iptr),
       double value AND double *iptr)
{
  *iptr = (double) ((int) value);
  return (value - *iptr);
}
#endif /* !HAVE_MODF */


  
