/* debug.c 
 * Debugging functions
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include "tua.h"

#ifdef DEBUG

#include <stdarg.h>

static CONST char * current_file_name;
static int current_line_number;

void
DEFUN (dbg_set_current_file_name, (filename),
       CONST char * filename)
{
  current_file_name = filename;
  current_line_number = 0;
}

void
DEFUN (dbg_message, (msg),
       CONST char * msg)
{
  if (current_line_number)
    fprintf (stderr, "%s:%d: %s\n", current_file_name, current_line_number, msg);
  else
    fprintf (stderr, "%s: %s\n", current_file_name, msg);
}

void
DEFUN_VOID (dbg_print_new_line_number)
{
  if ((++current_line_number % 50)==0 && be_verbose)
    fprintf (stderr, "\r%6d", current_line_number);
}

void
DEFUN_VOID (dbg_end)
{
  if (be_verbose)
    fprintf (stderr, "\r%6d", current_line_number);
}

void
DEFUN (dbg_printf, (fmt),
       CONST char * fmt DOTS)
{
  va_list ap;

  if (current_line_number)
    fprintf (stderr, "%s:%d: ", current_file_name, current_line_number);
  else
    fprintf (stderr, "%s: ", current_file_name);
  
  va_start (ap, fmt);
  vfprintf (stderr, fmt, ap);
  fprintf (stderr, "\n");
}

#endif /* DEBUG */

#if !defined(__GNUC__) || (__GNUC__ < 2) || (defined (__NeXT__) && !defined (__NeXT))

void
DEFUN (dbg_printf, (msg),
       CONST char * msg DOTS)
{
  /*
   * no op function. This is necessary to handle the varargs macros if we
   * are not using GCC 2.x
   */
}

#endif
