/* procuuxqt.c -- Read an process .Log/uuxqt/
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include    "tua_4_hdb.h"

#ifdef HDB_UUCP

#if defined(DIRENT) || defined(_POSIX_VERSION)
#include <dirent.h>
#define NLENGTH(dirent) (strlen((dirent)->d_name))
#else /* not (DIRENT or _POSIX_VERSION) */
#define dirent direct
#define NLENGTH(dirent) ((dirent)->d_namlen)
#ifdef USG
#ifdef SYSNDIR
#include <sys/ndir.h>
#else /* not SYSNDIR */
#include <ndir.h>
#endif /* not SYSNDIR */
#else /* not USG */
#include <sys/dir.h>		/* Assume SYSDIR, or not if you want. */
#endif /* not USG */
#endif /* not (DIRENT or _POSIX_VERSION) */

static void
DEFUN (ProcUuxqtEntry, (fp, sys),
       FILE * fp AND
       char *sys)
{
  char line[LINE_BUFFER_SIZE];
  system_rec_t *sr = insert_system (sys);

  if (!sr->Killed)
    {
      while (fgets (line, LINE_BUFFER_SIZE, fp) != NULL)
	{
	  /* uucp cci  (11/21-7:15:02,24502,0) croot */
	  command_rec_t *cr;
	  day_rec_t *dr;
	  Date_t Date;
	  extern int EXFUN(atoi, (CONST char *));
	  char *command;

	  debug_newline ();
	  
	  (void) strtok (line, "(");
	  Date.Month = atoi (strtok (NULL, "/"));
	  Date.Day = atoi (strtok (NULL, "-"));
	  dr = insert_day (Date);

	  (void) strtok (NULL, ") ");	/* The stuff in the brakets */

	  command = strtok (NULL, " ");
	  /* now if we are parsing a standard HDB log, in command we have
	   * the name of the user, or the word "COMMAND" if we are looking
	   * at an error.
	   * With an HDB_LOGGING Taylor we have one of "Executing", "ERROR:"
	   * or "Execution" */
	  
	  if (fstrcmp (command, "COMMAND") == 0)
	    {
	      /* uucp iconet  (3/6-2:06:23,24578,0) COMMAND FAIL (rnews ... */

	      char buffer[LINE_BUFFER_SIZE];
	      
	      (void) strtok (NULL, "("); /* skil "FAIL" */
	      command = strtok (NULL, ")");
	      sprintf (buffer, "%s [COMMAND FAIL]", command);
	      cr = insert_command (&sr->Commands, buffer);
	      cr->Number++;
	      cr = insert_command (&dr->Commands, buffer);
	      cr->Number++;
	    }
	  else if (fstrcmp (command, "Executing") == 0)
	    {
	      /* Taylor Uucp:
	       * news grimski (10/13-09:17:08,18771,0) Executing X.tantaluX2457 (relay rnews frcs) */

	      strtok (NULL, "(");
	      command = strtok (NULL, ")");
	      cr = insert_command (&sr->Commands, command);
	      cr->Number++;
	      cr = insert_command (&dr->Commands, command);
	      cr->Number++;
	    }
	  else if (fstrcmp (command, "ERROR:") == 0)
	    {
	      /* Taylor Uucp:
	       * news grimski (10/13-02:20:52,12161,0) ERROR: open (grimski/D.tantaluN213d): No such file or directory */

	      cr = insert_command (&sr->Commands, command+sizeof ("ERROR:"));
	      cr->Number++;
	      cr = insert_command (&dr->Commands, command+sizeof ("ERROR:"));
	      cr->Number++;	      
	    }
	  else if (fstrcmp (command, "Execution") == 0)
	    {
	      /* Taylor Uucp:
	       * news grimski (10/13-02:20:52,12161,0) Execution failed (X.tantaluX213c) */
	    }
	  else
	    {
	      command = strtok (NULL, "(");
	      if (fstrcmp (command, "XQT DENIED ") == 0)
		{
		  /* XQT DENIED (rnews ) */
		  
		  char buffer[LINE_BUFFER_SIZE];
		  
		  command = strtok (NULL, ")");
		  sprintf (buffer, "%s [EXECUTION DENIED ON LOCAL HOST]", command);
		  cr = insert_command (&sr->Commands, buffer);
		  cr->Number++;
		  cr = insert_command (&dr->Commands, buffer);
		  cr->Number++;
		}
	      else if (strbegcmp (command, "XQT- ") == 0)
		{
		  /* XQT-  STDIN/STDOUT/FILE ACCESS DENIED (uucp -C ~algol/x* cci!/user/algol ) */
		  
		  char buffer[LINE_BUFFER_SIZE];
		  char * message = command+sizeof ("XQT- ");
		  
		  command = strtok (NULL, ")");

		  sprintf (buffer, "%s [%s]", command, message);
		  cr = insert_command (&sr->Commands, buffer);
		  cr->Number++;
		  cr = insert_command (&dr->Commands, buffer);
		  cr->Number++;
		}
	      else
		{
		  /* (PATH=/bin:/usr/bin:/usr/lbin  LOGNAME=uucp UU_MACHINE=cci UU_USER=croot export UU_MACHINE UU_USER PATH; rmail algol ) */
		  
		  (void) strtok (NULL, ";");
		  if (command = strtok (NULL, ")"))
		    {
		      command++;	/* Skip the initial space */
		      cr = insert_command (&sr->Commands, command);
		      cr->Number++;
		      cr = insert_command (&dr->Commands, command);
		      cr->Number++;
		    }
		}
	    }
	}
    }
}

int
DEFUN_VOID (read_uuxqt_log)
{
  DIR *dirfp = NULL;
  struct dirent *direntry;
  char dirname[LPNMAX];
  int ret_value = OK;

  if (do_command_report_opt)
    {
      sprintf (dirname, "%s/%s", logs_prefix_path_opt, UUXQT_DIR);
      if ((dirfp = opendir (dirname)) == NULL)
	{
	  LOG ("cannot read %s", dirname);
	  ret_value = ERROR;
	}
      else
	{
#ifdef DEBUG
	  if (be_verbose)
	    fputs ("\nProcessing uuxqt logs:", stderr);
#endif
	  
	  while ((direntry = readdir (dirfp)) != NULL)
	    {
	      FILE *XqtFp;
	      char PathName[LPNMAX];
	      char System[15];

	      if (*direntry->d_name == '.')
		continue;

	      sprintf (System, "%.*s", (int) NLENGTH (direntry), direntry->d_name);

	      if (just_some_system_opt &&
		  (search_system (System) == (system_rec_t *) NULL))
		continue;

	      sprintf (PathName, "%s/%s/%s", logs_prefix_path_opt, UUXQT_DIR, System);
	      debug_filename (PathName);
	      if ((XqtFp = fopen (PathName, "r")) == (FILE *) NULL)
		{
		  LOG ("cannot open %s", PathName);
		  ret_value = ERROR;
		  break;
		}

	      ProcUuxqtEntry (XqtFp, System);
	      debug_end();
	      fclose (XqtFp);
	    }
	}
    }

  if (dirfp)
    closedir (dirfp);

  return ret_value;
}

#endif /* HDB_UUCP */
