/* pcdl.h - Definitions for parsing a Phone Category Definition Language
 *
 * This file is part of TUA.
 *
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _PCDL_H
#define _PCDL_H

#include "tua.h"

typedef struct pcdl_slot
{
  short from, to, cost;
} pcdl_slot;

typedef struct pcdl_slot_list
{
  pcdl_slot * slot;
  struct pcdl_slot_list * next;
} pcdl_slot_list;

typedef struct pcdl_name
{
  short cost;
  char * name;
} pcdl_name;

typedef struct pcdl_name_list
{
  pcdl_name * name;
  struct pcdl_name_list * next;
} pcdl_name_list;

typedef struct pcdl_day_slots
{
  short day;
  pcdl_slot_list slots;
} pcdl_day_slots;

typedef struct pcdl_country
{
  char * name;
  pcdl_name_list * names;
  pcdl_slot_list * slots[7];
} pcdl_country;

extern void EXFUN(pcdl_reset_slots, (NOARGS));
extern void EXFUN(pcdl_reset_names, (NOARGS));

extern pcdl_slot_list * EXFUN(pcdl_slots, (NOARGS));
extern pcdl_name_list * EXFUN(pcdl_names, (NOARGS));
     
extern pcdl_slot * EXFUN(pcdl_create_new_slot, (NOARGS));
extern pcdl_slot * EXFUN(pcdl_insert_slot, (pcdl_slot * slot));

extern pcdl_name * EXFUN(pcdl_create_new_name, (NOARGS));
extern pcdl_name * EXFUN(pcdl_insert_name, (pcdl_name * name));

extern int EXFUN(pcdl_lookup_rate_symbol, (CONST char * symbol, int ins_flag));
extern void EXFUN(pcdl_destroy_symbol_list, (NOARGS));
     
extern CONST char * EXFUN(pcd_rate_name, (int rate));
extern CONST char * default_country_name;
extern pcdl_country current_country;
extern int pcd_names_count;

#endif /* ifdef _PCDL_H */
