
/*  A Bison parser, made from pcdl_gram.y  */

#define YYBISON 1  /* Identify Bison output.  */

#define	PCKW_COUNTRY	258
#define	PCKW_INT	259
#define	PCKW_STRING	260
#define	PCKW_DAY	261
#define	PCKW_RATE	262
#define	PCKW_NAME	263
#define	PCKW_DEFAULT	264

#line 23 "pcdl_gram.y"

  #include "pcdl.h"

  static pcdl_slot_list * days[7];

  pcdl_country current_country = { 0, 0, { 0, 0, 0, 0, 0, 0, 0 }};

  static void EXFUN(yyerror, (CONST char * s));
  static int EXFUN(yylex, (NOARGS));
  
#line 34 "pcdl_gram.y"
typedef union {
  int ival;
  char * string;
  pcdl_country country;
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		67
#define	YYFLAG		-32768
#define	YYNTBASE	17

#define YYTRANSLATE(x) ((unsigned)(x) <= 264 ? yytranslate[x] : 29)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    15,    14,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    16,    11,     2,
    10,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    12,     2,    13,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     7,    12,    17,    21,    22,    25,    27,
    29,    35,    41,    46,    53,    57,    58,    61,    69,    81,
    89,   101
};

#endif

static const short yyrhs[] = {    -1,
    17,    19,     0,    17,    18,     0,     9,    10,     5,    11,
     0,     3,     5,    10,    20,     0,    12,    21,    13,     0,
     0,    21,    22,     0,    23,     0,    24,     0,     8,     4,
    10,     5,    11,     0,     8,     5,    10,     5,    11,     0,
     6,    10,    25,    11,     0,     6,    14,     6,    10,    25,
    11,     0,    12,    26,    13,     0,     0,    26,    27,     0,
     7,     4,    10,    28,    14,    28,    11,     0,     7,     4,
    10,    28,    14,    28,    15,    28,    14,    28,    11,     0,
     7,     5,    10,    28,    14,    28,    11,     0,     7,     5,
    10,    28,    14,    28,    15,    28,    14,    28,    11,     0,
     4,    16,     4,     0
};

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    54,    55,    98,   105,   110,   125,   128,   129,   132,   133,
   136,   144,   154,   158,   176,   179,   180,   183,   194,   211,
   221,   241
};

static const char * const yytname[] = {   "$","error","$illegal.","PCKW_COUNTRY",
"PCKW_INT","PCKW_STRING","PCKW_DAY","PCKW_RATE","PCKW_NAME","PCKW_DEFAULT","'='",
"';'","'{'","'}'","'-'","','","':'","input","default_country","country_defn",
"defn_block","defn_stmts","defn_stmt1","name_stmt","day_stmt","day_block","rates_stmts",
"rates_stmt1","hour",""
};
#endif

static const short yyr1[] = {     0,
    17,    17,    17,    18,    19,    20,    21,    21,    22,    22,
    23,    23,    24,    24,    25,    26,    26,    27,    27,    27,
    27,    28
};

static const short yyr2[] = {     0,
     0,     2,     2,     4,     4,     3,     0,     2,     1,     1,
     5,     5,     4,     6,     3,     0,     2,     7,    11,     7,
    11,     3
};

static const short yydefact[] = {     1,
     0,     0,     0,     3,     2,     0,     0,     0,     0,     7,
     5,     4,     0,     0,     0,     6,     8,     9,    10,     0,
     0,     0,     0,    16,     0,     0,     0,     0,     0,    13,
     0,     0,     0,     0,    15,    17,     0,    11,    12,     0,
     0,    14,     0,     0,     0,     0,     0,     0,     0,     0,
    22,     0,     0,    18,     0,    20,     0,     0,     0,     0,
     0,     0,     0,    19,    21,     0,     0
};

static const short yydefgoto[] = {     1,
     4,     5,    11,    13,    17,    18,    19,    25,    29,    36,
    46
};

static const short yypact[] = {-32768,
     1,     4,     5,-32768,-32768,    11,    18,    17,    19,-32768,
-32768,-32768,     6,    -7,    21,-32768,-32768,-32768,-32768,    20,
    25,    24,    26,-32768,    22,    27,    30,    33,    -5,-32768,
    20,    28,    29,    23,-32768,-32768,    31,-32768,-32768,    34,
    35,-32768,    37,    37,    32,    36,    38,    39,    37,    37,
-32768,     7,     9,-32768,    37,-32768,    37,    40,    41,    37,
    37,    42,    45,-32768,-32768,    46,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,    16,-32768,-32768,
   -44
};


#define	YYLAST		56


static const short yytable[] = {    47,
    66,    34,    20,     2,    52,    53,    21,    35,     6,     3,
    58,    14,    59,    15,     7,    62,    63,    54,    16,    56,
     8,    55,     9,    57,    22,    23,    40,    41,    10,    12,
    26,    24,    30,    27,    32,    28,    31,    33,    38,    39,
    45,    42,    51,    43,    44,    67,    37,    48,     0,    49,
     0,    50,    64,    60,    61,    65
};

static const short yycheck[] = {    44,
     0,     7,    10,     3,    49,    50,    14,    13,     5,     9,
    55,     6,    57,     8,    10,    60,    61,    11,    13,    11,
    10,    15,     5,    15,     4,     5,     4,     5,    12,    11,
     6,    12,    11,    10,     5,    10,    10,     5,    11,    11,
     4,    11,     4,    10,    10,     0,    31,    16,    -1,    14,
    -1,    14,    11,    14,    14,    11
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 169 "/usr/local/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
		 &yyls1, size * sizeof (*yylsp),
#endif
		 &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 55 "pcdl_gram.y"
{
    /* Ok, we have a complete country definition. First of all destroy the
     * symbol table, since we are not going to use it anymore. Then, if the
     * country name matches the default one (specificated by either --country
     * option or with the "default" clause), store it and return.
     * Otherwise go on with the next */

    pcdl_destroy_symbol_list ();
    if (default_country_name && fstrcmp (default_country_name, yyvsp[0].country.name) == 0)
      {
      	current_country = yyvsp[0].country;
      	YYACCEPT;
      }

  #ifdef TEST  
    else
      {
      	pcdl_name_list * nl = yyvsp[0].country.names;
      	pcdl_slot_list * sl;
      	int day;

      	printf ("Name: %s\n", yyvsp[0].country.name);
      	while (nl)
	  {
	    printf ("\tcost %d='%s'\n", nl->name->cost, nl->name->name);
	    nl = nl->next;
	  }

      	for (day=0; day<7; day++)
	  {
	    printf ("\t* Setup for day %d\n", day);
	    sl = yyvsp[0].country.slots[day];
	    while (sl)
	      {
	      	printf ("\tfrom %d to %d costs %d\n",
		      	sl->slot->from, sl->slot->to,
		      	sl->slot->cost);
	      	sl = sl->next;
	      }
	  }
      }
  #endif
  ;
    break;}
case 3:
#line 98 "pcdl_gram.y"
{
    /* if the country is not yet set (via --country option) */
    if (default_country_name == 0)
      default_country_name = yyvsp[0].string;
  ;
    break;}
case 4:
#line 105 "pcdl_gram.y"
{
    yyval.string = yyvsp[-1].string;
  ;
    break;}
case 5:
#line 110 "pcdl_gram.y"
{
    int day;

    yyval.country.name = yyvsp[-2].string;
    yyval.country.names = pcdl_names();
    for(day=0; day<7; day++)
      yyval.country.slots[day] = days[day];

    pcdl_reset_slots();
    pcdl_reset_names();

    /* printf ("GRAM: name=%s names=%p \n", $2, $$.names); */
  ;
    break;}
case 11:
#line 136 "pcdl_gram.y"
{
    pcdl_name * new = pcdl_create_new_name();

    new->cost = yyvsp[-3].ival;
    new->name = yyvsp[-1].string;
    pcdl_insert_name (new);
    /* printf ("GRAM: found a name (%d=%s)\n", $2, $4); */
  ;
    break;}
case 12:
#line 144 "pcdl_gram.y"
{
    int cost = pcdl_lookup_rate_symbol (yyvsp[-3].string, TRUE);
    pcdl_name * new = pcdl_create_new_name();

    new->cost = cost;
    new->name = yyvsp[-1].string;
    pcdl_insert_name (new);
  ;
    break;}
case 13:
#line 154 "pcdl_gram.y"
{
    days[yyvsp[-3].ival] = pcdl_slots();
    pcdl_reset_slots();
  ;
    break;}
case 14:
#line 158 "pcdl_gram.y"
{
    int day;

    if (yyvsp[-5].ival > yyvsp[-3].ival)
      {
      	int swap = yyvsp[-5].ival;

      	yyvsp[-5].ival = yyvsp[-3].ival;
      	yyvsp[-3].ival = swap;
      }

    for (day=yyvsp[-5].ival; day<=yyvsp[-3].ival; day++)
      days[day] = pcdl_slots();

    pcdl_reset_slots();
  ;
    break;}
case 18:
#line 183 "pcdl_gram.y"
{
    pcdl_slot * new = pcdl_create_new_slot();

    new->from = yyvsp[-3].ival;
    new->to = yyvsp[-1].ival;
    new->cost = yyvsp[-5].ival;

    pcdl_insert_slot (new);

    /* printf ("GRAM: found a slot (cost=%d from %d to %d)\n", $2, $4, $6); */
  ;
    break;}
case 19:
#line 194 "pcdl_gram.y"
{
  pcdl_slot * new = pcdl_create_new_slot();

  new->from = yyvsp[-7].ival;
  new->to = yyvsp[-5].ival;
  new->cost = yyvsp[-9].ival;

  pcdl_insert_slot (new);

  new = pcdl_create_new_slot();

  new->from = yyvsp[-3].ival;
  new->to = yyvsp[-1].ival;
  new->cost = yyvsp[-9].ival;

  pcdl_insert_slot (new);
;
    break;}
case 20:
#line 211 "pcdl_gram.y"
{
    pcdl_slot * new = pcdl_create_new_slot();
    int cost = pcdl_lookup_rate_symbol (yyvsp[-5].string, FALSE);

    new->from = yyvsp[-3].ival;
    new->to = yyvsp[-1].ival;
    new->cost = cost;

    pcdl_insert_slot (new);
  ;
    break;}
case 21:
#line 221 "pcdl_gram.y"
{
    pcdl_slot * new = pcdl_create_new_slot();
    int cost = pcdl_lookup_rate_symbol (yyvsp[-9].string, FALSE);

    new->from = yyvsp[-7].ival;
    new->to = yyvsp[-5].ival;
    new->cost = cost;

    pcdl_insert_slot (new);

    new = pcdl_create_new_slot();

    new->from = yyvsp[-3].ival;
    new->to = yyvsp[-1].ival;
    new->cost = cost;

    pcdl_insert_slot (new);
  ;
    break;}
case 22:
#line 241 "pcdl_gram.y"
{
    yyval.ival = yyvsp[-2].ival*60 + yyvsp[0].ival;
  ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 442 "/usr/local/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 246 "pcdl_gram.y"

#include <ctype.h>

#define SYM_LENGTH 30

#if defined (__GNUC__) && !defined(__STRICT_ANSI__)
__inline__
#endif
int
DEFUN (strequ, (s1, s2),
       char * s1 AND char * s2)
{
  return (strcasecmp (s1, s2) == 0);
}

static CONST char * pcd_filename;
static FILE * pcd_file;
static int current_line = 0;

int pcd_names_count = 0;

static void
DEFUN(yyerror, (s),
      CONST char * s)
{
  printf ("TUA:%s:%d: %s\n", pcd_filename, current_line, s);
}

int
DEFUN(parse_pcd_file, (pathname),
      CONST char * pathname)
{
  pcd_filename = pathname;
  if ((pcd_file = fopen (pathname, "r")) && yyparse() == 0)
    {
      pcdl_name_list * nl = current_country.names;

      pcd_names_count = 0;
      while (nl)
	{
	  pcd_names_count++;
	  nl = nl->next;
	}
      fclose (pcd_file);

      
      return OK;
    }
  else
    return ERROR;
}

static int
DEFUN_VOID(yylex)
{
  int c;

read_again:  
  while ((c = getc(pcd_file)) == ' ' || c == '\t' || c == '\n')
    if (c == '\n')
      current_line++;

  if (c == '#')
    {
      do
	{
	  c = getc(pcd_file);
	} while (c != EOF && c != '\n');
      current_line++;
      
      if (c != EOF)
	goto read_again;
    }
  
  if (c == EOF)
    return 0;

  if (isdigit (c))
    {
      ungetc (c, pcd_file);
      fscanf (pcd_file, "%d", &yylval.ival);
      return PCKW_INT;
    }

  if (isalpha (c))
    {
      char symbol[SYM_LENGTH];
      int i = 0;

      do
	{
	  symbol[i++] = c;
	  if (i == SYM_LENGTH)
	    {
	      fprintf (stderr, "error: symbol %.30s... too long!\n", symbol);
	      exit (1);
	    }
	  c = getc(pcd_file);
	} while (c != EOF && isalnum (c));

      ungetc (c, pcd_file);
      symbol[i] = 0;

      if (strequ (symbol, "COUNTRY")) return PCKW_COUNTRY;
      else if (strequ (symbol, "NAME")) return PCKW_NAME;
      else if (strequ (symbol, "RATE")) return PCKW_RATE;
      else if (strequ (symbol, "DEFAULT")) return PCKW_DEFAULT;
      else if (strequ (symbol, "SUN") || strequ (symbol, "SUNDAY"))
	{
	  yylval.ival = 0;
	  return PCKW_DAY;
	}
      else if (strequ (symbol, "MON") || strequ (symbol, "MONDAY"))
	{
	  yylval.ival = 1;
	  return PCKW_DAY;
	}
      else if (strequ (symbol, "TUE") || strequ (symbol, "TUESDAY"))
	{
	  yylval.ival = 2;
	  return PCKW_DAY;
	}
      else if (strequ (symbol, "WED") || strequ (symbol, "WEDNESDAY"))
	{
	  yylval.ival = 3;
	  return PCKW_DAY;
	}
      else if (strequ (symbol, "THU") || strequ (symbol, "THURSDAY"))
	{
	  yylval.ival = 4;
	  return PCKW_DAY;
	}
      else if (strequ (symbol, "FRI") || strequ (symbol, "FRIDAY"))
	{
	  yylval.ival = 5;
	  return PCKW_DAY;
	}
      else if (strequ (symbol, "SAT") || strequ (symbol, "SATURDAY"))
	{
	  yylval.ival = 6;
	  return PCKW_DAY;
	}
      else
	{
	  yylval.string = savestring (symbol);
	  return PCKW_STRING;
	}
    }

  if (c == '"')
    {
      char string[SYM_LENGTH];
      int i;

      for (i=0, c = getc(pcd_file); c != EOF && c != '"'; i++, c = getc(pcd_file))
	string[i] = c;

      string[i] = 0;
      yylval.string = savestring (string);
      return PCKW_STRING;
    }

  return c;
}

#if TEST
main()
{
  pcd_file = stdin;
  if (yyparse() == 0)
    {
      pcdl_name_list * nl = current_country.names;
      pcdl_slot_list * sl;
      int day;
      
      printf ("Name: %s\n", current_country.name);
      while (nl)
	{
	  printf ("\tcost %d='%s'\n", nl->name->cost, nl->name->name);
	  nl = nl->next;
	}
      
      
      for (day=0; day<7; day++)
	{
	  printf ("\t* Setup for day %d\n", day);
	  sl = current_country.slots[day];
	  while (sl)
	    {
	      printf ("\tfrom %d to %d costs %d\n", sl->slot->from, sl->slot->to, sl->slot->cost);
	      sl = sl->next;
	    }
	}
    }
}
  
#endif /* TEST */
