/* phonesw.c -- Return an index based on the day, hour and minute we are working
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "tua.h"
#include "pcdl.h"

int
DEFUN(get_phone_price, (dow, hour, min),
      int dow AND int hour AND int min)
{
  pcdl_slot_list * sl = current_country.slots[dow];
  short minutes = hour*60 + min;

  while (sl)
    {
      if (sl->slot->from <= minutes && minutes < sl->slot->to)
	return sl->slot->cost-1;

      sl = sl->next;
    }

  return 0;
}
  
