/*
 * Written by Mike Stefanik
 *
 * Since it would be rather ridiculous to copyright (or copyleft) this
 * little snippit of code, it is released into the public domain.  Use
 * as you will.
 *
 * tmparse(3) will parse a date specification, and return the time in
 * natural format (the number of seconds since Jan 1, 1970 00:00)
 *
 * The buffer can contain the date portion (ie: 3/29/91), the time portion
 * (ie: 14:00:34), or both.   If no time is entered, the default is the
 * current time; if no date is entered, the default is the current date.
 *
 */

/*
 * Modified to deal with fixed format as the uucico's one: mm/dd-hh:mm:ss
 * Since those silly logs are missing the year, I have to compare the
 * month and the day with the current one: if they are greater, clearly
 * they refer to the last year...
 *
 * Changed tmparse(buf,when) to get_date(buf) for compatibility with the
 * rest of TUA.
 *
 * piggy@idea.sublink.org - 6 Apr 1991
 */

#include "tua.h"
#include <time.h>

Julian_t
DEFUN (parse_date, (buf),
       CONST char *buf)
{
  Julian_t julian;
  Date_t Date;
  Time_t Time;
  struct tm *lt;
#ifdef HDB_UUCP
  static int current_year, current_month, current_day;

#ifdef TAYLOR_UUCP
  if (! is_taylor_uucp)
#endif
    {
      static long now = -1L;
      
      if (now == -1L)		/* Is it the first time that they call you? */
	{
	  extern time_t EXFUN (time, (long *));
	  
	  time (&now);
	  lt = localtime (&now);
	  current_year = lt->tm_year + 1900;
	  current_month = lt->tm_mon + 1;
	  current_day = lt->tm_mday;
	}
    }

#endif /* HDB_UUCP */
  
#if 0
  debug_printf ("Converting %s...", buf);
#endif
  
#if defined (BOTH_OF_THEM)
  if (is_taylor_uucp)
#endif
#ifdef TAYLOR_UUCP
    {
      unsigned int year, month, day;
      unsigned int hour, min, sec, cent;

#ifdef __STDC__
      sscanf ((char *) buf, "%u-%u-%u %u:%u:%u.%u",
	      &year, &month, &day,
	      &hour, &min, &sec, &cent);
#else
      sscanf ((char *) buf, "%d-%d-%d %d:%d:%d.%d",
	      &year, &month, &day,
	      &hour, &min, &sec, &cent);
#endif
      Date.Year = year;
      Date.Month = month;
      Date.Day = day;
      Time.Hour = hour;
      Time.Min = min;
      Time.Sec = sec;
      Time.Cent = cent;
    }
#endif  
#if defined(BOTH_OF_THEM)
  else
#endif
#ifdef HDB_UUCP
    {
      unsigned int month, day;
      unsigned int hour, min, sec;

#ifdef __STDC__
      sscanf ((char *) buf, "%u/%u-%u:%u:%u", &month, &day, &hour, &min, &sec);
#else
      sscanf ((char *) buf, "%d/%d-%d:%d:%d", &month, &day, &hour, &min, &sec);
#endif      
      Date.Month = month;
      Date.Day = day;
      Time.Hour = hour;
      Time.Min = min;
      Time.Sec = sec;

    }
#endif

#ifdef HDB_UUCP
  
#ifdef TAYLOR_UUCP
  if (! is_taylor_uucp)
#endif    
    /*
     * Check the day vs current_day and month vs current_month to if their
     * year was last year or the current one.
     * Thanx to all uucico engineers!
     */

    if (current_month < Date.Month || (current_month == Date.Month && current_day < Date.Day))
      Date.Year = current_year - 1;
    else
      Date.Year = current_year;

#endif /* HDB_UUCP */

#if 0
  debug_printf ("... obtaining %u/%u-%u:%u:%u ...",
		Date.Month, Date.Day, Time.Hour, Time.Min, Time.Sec);
#endif
  
  dt_to_julian (Date, Time, &julian);

#if 0
  debug_printf ("... and %f as julian value", julian);
#endif
  
  return (julian);
}

#ifdef MAIN

int is_taylor_uucp = 1;

main ()
{
  char buf[64];
  size_t when;

  while (gets (buf) != NULL)
    {
      when = parse_date (buf);
      printf ("%lu - %s", when, ctime (&when));
    }
}

#endif
