.TH OLXVMAN 1 "Release 1.0" "X Version 11 Release 4"
.SH NAME
olxvman - Manual page display program for the X Window System.
.SH SYNOPSIS
.B olxvman
[ generic-toolkit-arguments ]
.SH DESCRIPTION
.I olxvman
is a XView-based manual page browser.  The default size of the initial \fIolxvman\fP
window is small so that you can leave it running throughout your entire login
session.  

The 
.I Options 
available in the drop-down menu for 
.I olxvman
are as follows:

.IP "\fISearch\fP"
Brings up the search window which allows the manual pages to be
searched for either a specific page, or pages with a specific topic.

.IP "\fIShow Version\fP"
Displays the current version of the program.

.IP "\fIPrint Current Page\fP"
Prints the manual page that is in the current manual
page display window. The current manual page display window is the window
that is unpinned. Manual pages in a pinned display window cannot be printed.

Man page are printed using troff on the unformated page.

.IP "\fIQuit\fP"
Exits olxvman.
.PP

The 
.I Manual Sections 
window provides a listing of the manual sections that are
available. Selecting a manual section will cause the manual pages for the
section to be displayed in the Manual Pages list.


The 
.I Manual Pages 
window is a listing of all manual pages that are available in
the current section. A manual page can be displayed by selecting an item in
the list.

If the manual page is not formatted for display, it will be formatted. If
the directory required for storing manual formatted manual pages has the
correct permissions, the user will be prompted to save the manual page.


An on-lime 
.I Help
is available by hitting the Help key.
.PP
.SH "CUSTOMIZING OLXVMAN"
.PP
.I olxvman
allows customization of the directories to be searched for manual pages.
Olxvman determines which directories it will
search by reading the \fIMANPATH\fP environment variable.  If no
\fIMANPATH\fP is found then a pre-compiled one is used.
This environment
is expected to be a colon-separated list of directories for olxvman to search.
.sp
.nf
setenv MANPATH /mit/kit/man:/usr/man
.fi
.PP
By default,
.I olxvman
will search each of the following directories (in each of the directories 
specified in the users MANPATH) for manual pages.  If manual pages exist
in that directory then they are added to list of manual pages for 
the corresponding menu item.
A menu item is only displayed for those sections that actually contain
manual pages.
.PP
.sh "THE MANDESC FILE"        
.PP
By using the \fImandesc\fP file a user or system manager is able to 
more closely control which manual pages will appear in each of the sections
represented by menu items in the \fISections\fP menu.  This 
functionality is only available on a section by section basis, and individual
manual pages may not be handled in this manner (Although generous use of 
symbolic links - ln(1) - will allow almost any configuration you can imagine).
.PP
.SH "COMMAND LINE OPTIONS"
.PP
Olxvman supports all standard XView Toolkit command line arguments (see
\fIxview(7)\fP).
.SH FILES
.IP "\fI<manpath directory>\fP/man<\fIcharacter\fP>" 2.5i
.IP "\fI<manpath directory>\fP/cat<\fIcharacter\fP>" 
.IP "\fI<manpath directory>\fP/mandesc" 
.PP
.SH "SEE ALSO"
xview(7)
.PP
.SH ENVIRONMENT
.TP 1.5i
.B MANPATH
the search path for manual pages.  Directories are separated by
colons (e.g. /usr/man:/mit/kit/man:/foo/bar/man).
.PP
.SH BUGS
There probably are some.
.SH COPYRIGHT
Based upon xman from X11R4 written by Chris D. Peterson.
Copyright 1988 by Massachusetts Institute of Technology.
.br
Ported By: Dan Pritchett, Sun Microsystems Federal, Inc
.br
This man page is borrowed from xman man page.
.SH AUTHORS
Chris Peterson, MIT X Consortium from the V10 version written by Barry
Shein formerly of Boston University.
