/*
   A quick hack to set the refresh timer to a longer period than the
   standard 15 microseconds. This is to help out people who have to
   have their Cx486DLC flush the internal cache on every DRAM refresh,
   because their motherboard doesn't support the Cx's FLUSH input.
   Non-cyrix users can still use this to get a bit of a boost on
   older machines that don't support hidden/120us refresh.

						Paul Gortmaker.

This code is copyright (c) 1994 by Paul Gortmaker. You are free
to treat it as described under the GNU General Public License v2.
See the file "COPYING" for details. 

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <asm/io.h>
#include <errno.h>

#define byte_out	outb		/* don't use outb_p */
#define TIMER_SEL	0x43
#define TIMER_DAT	0x41

#ifdef _USE_IOPL			/* use iopl() w cli/sti pair */
#define IOPL_HI		3
#define IOPL_LO		0

#else					/* use ioperm() w/o cli/sti pair */
#define PORT_IO_ON	1
#define PORT_IO_OFF	0
#endif

unsigned short dram_refresh;
unsigned char dram_timer_lo;
unsigned char dram_timer_hi;

int main(int argc, char *argv[]) {

if (argc!=2) {
    fprintf(stderr,"\nUsage: %s <time>\n\t\twhere <time> is the DRAM refresh period in us.\n\n",argv[0]);
    return(0);
}

dram_refresh=atoi(argv[1]);

if (dram_refresh<15) {
	fprintf(stderr,"\nDRAM refresh more frequent than 15 microseconds? Ha!\n\n");
	return(EINVAL);
}

else if (dram_refresh>55000) {
	fprintf(stderr,"\nDRAM refresh period must be less than 55000 microseconds.\n\n");
	return(EINVAL);
}

else if (dram_refresh>5000) {
	fprintf(stderr,"\n\bWARNING: Setting the refresh rate above 5000us is STRONGLY DISCOURAGED!\n\n");
	fprintf(stderr,"\tYou have 5 seconds to hit ^C to abort....\n\n");
	sleep(5);
}

dram_refresh=(unsigned short)(dram_refresh*1.193+.5);
/* timer is clocked at 1.19 MHz -- PC std. */

dram_timer_hi=dram_refresh/0x100;
dram_timer_lo=dram_refresh%0x100;

#ifdef _USE_IOPL

if (iopl(IOPL_HI)) {
	perror("iopl");
	fprintf(stderr,"dram: You must be root to alter the refresh timer.\n");
	return(EPERM);
}

asm("cli");

#else

if (ioperm(TIMER_DAT,3,PORT_IO_ON)) {
	perror("ioperm");
	fprintf(stderr,"dram: You must be root to alter the refresh timer.\n");
	return(EPERM);
}

#endif

byte_out(0x74,TIMER_SEL);
byte_out(dram_timer_lo,TIMER_DAT);
byte_out(dram_timer_hi,TIMER_DAT);

#ifdef _USE_IOPL
asm("sti");
iopl(IOPL_LO);

#else
ioperm(TIMER_DAT,3,PORT_IO_OFF);

#endif

return (0);	/* Did we crash yet? */

}
