/*
 * veridata.c (routine to test if it is the right type of computer)
 * Time-stamp: <04 Aug 94 (15:06:08) by pive@ruca.ua.ac.be>
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include "veridata.h"

#ifndef NO_CHECK
unsigned int check_type()
{
  int mem_fd;
  unsigned short c;
  
  if ((mem_fd = open("/dev/mem",O_RDONLY)) < 0) {
    fprintf(stderr,"Can't open /dev/mem for reading\n");
    return(FALSE);
  }
  if (lseek(mem_fd,VERIDATA_ADDR,SEEK_SET) != VERIDATA_ADDR) {
    fprintf(stderr,"Can't find ROM address: %x\n",VERIDATA_ADDR);
    close(mem_fd);
    return(FALSE);
  }
  if (read(mem_fd,&c,2) != 2) {
    fprintf(stderr,"Can't read at ROM address: %x or %x\n",
	    VERIDATA_ADDR,VERIDATA_ADDR+1);
    close(mem_fd);
    return(FALSE);
  }
  close(mem_fd);
  if (c != 0xaa55) { /* ([0x000] != 0x55) && ([0x001] != 0xaa) */
    fprintf(stderr,"Wrong computer type\n");
    return(FALSE);
  } 
  return(TRUE);
}
#endif
