/* mconv2 version 0.1 */

#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <errno.h>

static char *prog_name, *ms_name=NULL, *ps2_name=NULL, *mse_name=NULL;
static int mouse, ms_fifo=0, ps2_fifo=0, mse_fifo=0;
int error;

void closefifos()
{
  if(ms_fifo>0) close(ms_fifo);
  if(ps2_fifo>0) close(ps2_fifo);
  if(mse_fifo>0) close(mse_fifo);
}

void openfifos()
{
  if(ms_name)
    if( (ms_fifo = open(ms_name, O_RDWR|O_NONBLOCK)) < 0 )
      goto error;
  if(ps2_name)
    if( (ps2_fifo = open(ps2_name, O_RDWR|O_NONBLOCK)) < 0 )
      goto error;
  if(mse_name)
    if( (mse_fifo = open(mse_name, O_RDWR|O_NONBLOCK)) < 0 )
      goto error;
  return;

 error:
  fprintf(stderr, "%s: Error reopening fifos.\n", prog_name);
  closefifos();
  close(mouse);
  exit(1);
}  

void handler()
{
  fprintf(stderr, "\n%s: killed!\n", prog_name);
  closefifos();
  close(mouse);
  exit(0);
}

void sigpipe_handler()
{
  closefifos();
  openfifos();
  signal(SIGPIPE, sigpipe_handler);
}
  

unsigned char getbyte(void)
{
  static unsigned char buf[1024];
  static unsigned char *bp = buf, *ep = buf;
  int n;

  if (bp == ep) {
    bp = ep = buf;
    n = read(mouse, buf, 1024);
    if (n>0) {
      ep += n;
    }
  }
  if(ps2_name) write(ps2_fifo, bp, 1); /* Copy out */
  return *bp++;
}

void copy_mouse(void)
{
  static unsigned char buf[1024];
  static unsigned char *bp = buf, *ep = buf;
  int n;

  while (1)
    {
      if (bp == ep) {
	bp = ep = buf;
	n = read(mouse, buf, 1024);
	if (n>0) {
	  ep += n;
	}
      }
      write(ps2_fifo, bp, 1); /* Copy out */
      bp++;
    }
}


void convert_mouse(void)
{
  unsigned char byte1, byte2, byte3, out[3], outbyte;
  int ret;

  while (1) {
    byte1 = getbyte();
    if (byte1 & 0xc0)
      continue;			        /* Resynchronize */
    byte2 = getbyte();
    byte3 = getbyte();
    byte3 = -byte3;
    outbyte = 0x40;
    outbyte |= ((byte2 >> 6)&0x03);
    outbyte |= ((byte3 >> 4)&0x0c);
    outbyte |= (byte1&0x01) << 5;	/* Left button */
    outbyte |= (byte1&0x02) << 3;	/* Right button */
    out[0] = outbyte;
    out[1] = (byte2)&0x3f;
    out[2] = (byte3)&0x3f;
    if( ms_name )
      {
	ret = write(ms_fifo, out, 3);
	error=errno;
	if ( (ret < 0) && (errno != EPIPE) && (errno != EAGAIN) )
	  return;
      }
    if( mse_name )
      {
	if(byte1&0x04)
	  outbyte |= 0x30;                  /* Middle button? */
	out[0] = outbyte;
	
	ret = write(mse_fifo, out, 3);
	error=errno;
	if ( (ret < 0) && (errno != EPIPE) && (errno != EAGAIN) )
	  return;
      }
  }
}


int main(int argc, char **argv)
{
  int a;

  prog_name = argv[0];
  if ( (argc < 4) || (argc&0x01) ) {
    fprintf(stderr, "Usage: %s <mouse dev> {-ms <msfifo>} {-ps2 <ps2fifo>} {-mse <msefifo>}\n", argv[0]);
    exit(1);
  }

  mouse = open(argv[1], O_RDONLY);

  if (mouse < 0) {
    error=errno;
    fprintf(stderr, "%s: error %d (%s) while opening\n%s:   real mouse device %s. Exiting.\n", prog_name, error, strerror(error), prog_name, argv[1] );
    closefifos();
    exit(1);
  }

  a=2;
  while( a<argc )
    {
      if( !strcmp("-ms",argv[a]) )
	 {
	   a++;
	   if( !ms_name )
	     {
	       ms_name = argv[a];
	       ms_fifo = open( ms_name, O_RDWR|O_NONBLOCK );
	       if( ms_fifo < 0 )
		 {
		   error=errno;
		   fprintf(stderr, "%s: error %d (%s) opening fifo %s. Exiting.\n", prog_name, error, strerror(error), ms_name);
		   exit(1);
		 }
	       printf( "%s: Microsoft mouse device at %s\n", prog_name, ms_name );
	     }
	   else
	     {
	       fprintf(stderr, "%s: ms-fifo allready connected to %s, ignoring %s\n",
		       prog_name, ms_name, argv[a] );
	     }
	 }

      else if( !strcmp("-ps2",argv[a]) )
	 {
	   a++;
	   if( !ps2_name )
	     {
	       ps2_name = argv[a];
	       ps2_fifo = open( ps2_name, O_RDWR|O_NONBLOCK );
	       if( ps2_fifo < 0 )
		 {
		   error=errno;
		   fprintf(stderr, "%s: error %d (%s) opening fifo %s. Exiting.\n", prog_name, error, strerror(error), ps2_name);
		   exit(1);
		 }
	       printf( "%s: PS/2 mouse device at %s\n", prog_name, ps2_name );
	     }
	   else
	     {
	       fprintf(stderr, "%s: ps2-fifo allready connected to %s, ignoring %s\n",
		       prog_name, ps2_name, argv[a] );
	     }
	 }

      else if( !strcmp("-mse",argv[a]) )
	 {
	   a++;
	   if( !mse_name )
	     {
	       mse_name = argv[a];
	       mse_fifo = open( mse_name, O_RDWR|O_NONBLOCK );
	       if( mse_fifo < 0 )
		 {
		   error=errno;
		   fprintf(stderr, "%s: error %d (%s) opening fifo %s. Exiting.\n", prog_name, error, strerror(error), mse_name);
		   exit(1);
		 }
	       printf( "%s: Mid-to-LR-button Microsoft mouse device at %s\n", prog_name, mse_name );
	     }
	   else
	     {
	       fprintf(stderr, "%s: mse-fifo allready connected to %s, ignoring %s\n",
		       prog_name, mse_name, argv[a] );
	     }
	 }

      else
	fprintf(stderr, "%s: unknown option \"%s\" ignored.\n", prog_name, argv[a] );
      a++;
    }

  signal(SIGTERM, handler);
  signal(SIGINT, handler);
  signal(SIGPIPE, sigpipe_handler);


/*  if( ms_name || mse_name ) /* Is microsoft emulation needed? */
    convert_mouse();

/*  else
    copy_mouse(); /* If not, use a simpler copy-loop */

  fprintf(stderr, "%s: error %d reading or writing (%s).\n", prog_name, error, strerror(error) );
  closefifos();
  close(mouse);
}










