
/* 
 * RENICE.C
 *
 * renice priority [[-p] pids...] [-g pgrp...] [-u users...]
 *
 * (c)Copyright 1994 by Matthew Dillon.
 *
 * Permissions granted as per the GNU Public License.
 *
 * bug reports and (appropriate) enhancements to dillon@apollo.west.oic.com
 * compile: gcc -O2 -s -N renice.c -o renice
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>
#include <pwd.h>
#include <errno.h>
#include <string.h>

void usage(int code);

#define VERSION	"1.00"

main(ac, av)
char *av[];
{
    short i;
    char state = PRIO_PROCESS;
    int pri;
    int code = 0;

    if (ac == 1) {
        usage(0);
    }

    pri = strtol(av[1], NULL, 0);

    for (i = 2; i < ac; ++i) {
        char *ptr = av[i];

        if (*ptr == '-') {
            ptr += 2;
            switch(ptr[-1]) {
            case 'p':
                state = PRIO_PROCESS;
                break;
            case 'g':
                state = PRIO_PGRP;
                break;
            case 'u':
                state = PRIO_USER;
                break;
	    default:
	        usage(1);
	        break;
	    }
	    continue;
        }
        switch(state) {
        case PRIO_USER:
            {
		struct passwd *pas;

		if (pas = getpwnam(ptr)) {
		    if (setpriority(state, pas->pw_uid, pri) < 0) {
			fprintf(stderr, "user %s: %s\n", ptr, strerror(errno));
			code = 1;
		    }
		} else {
		    fprintf(stderr, "user %s: no such user\n", ptr);
		    code = 1;
		}
	    }
	    break;
	case PRIO_PROCESS:
	    {
	        int pid = strtol(ptr, NULL, 0);

		if (setpriority(state, strtol(ptr, NULL, 0), pri) < 0) {
		    fprintf(stderr, "pid %d: %s\n", pid, strerror(errno));
		    code = 1;
		}
	    }
	    break;
	case PRIO_PGRP:
	    {
	        int pgrp = strtol(ptr, NULL, 0);

		if (setpriority(state, strtol(ptr, NULL, 0), pri) < 0) {
		    fprintf(stderr, "pgrp %d: %s\n", pgrp, strerror(errno));
		    code = 1;
		}
	    }
	    break;
        }
    }
    exit(code);
}

void
usage(int code)
{
    puts("renice priority [[-p] pids...] [-g pgrp...] [-u users...]");
    puts("version " VERSION ", by Matthew Dillon");
    exit(code);
}

