/* RUNAS -- Version 1.01                                    */
/* Copyright (C) 1994 -- S. Joel Katz (Stimpson@Panix.COM) */
/* May be freely distributed and modified.                 */
/* Suggestions or improvements are welcome.                */

/* To compile, use "gcc runas.c -o runas"                  */

#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <getopt.h>
#include <pwd.h>
#include <grp.h>

extern int errno, optind, optopt;
extern char *optarg, **environ;

void usage(void)
{
  fprintf(stderr,"\nUsage:");
  fprintf(stderr,
    " runas [ options ] [ -- ] user_name executable [ param1, param2, ... ]");
  fprintf(stderr,"\n\nThe following options are available:\n");
  fprintf(stderr,"   -d directory   Set the initial directory\n");
  fprintf(stderr,"   -c directory   Set the root directory\n");
  fprintf(stderr,"   -g             Run in own process group\n");
  fprintf(stderr,"   -p number      Adjust priority (-20 = max, 20 = min)\n");
  fprintf(stderr,"   -i filename    Redirect input from file\n");
  fprintf(stderr,"   -o filename    Redirect output to file\n");
  fprintf(stderr,"   -e filename    Redirect errors to file\n\n");
  fprintf(stderr,"Order of execution is:\n");
  fprintf(stderr,
    "Change group, change directory, redirect, change root,\n");
  fprintf(stderr,
    "establish process group, set priority, change user id, execute.\n\n");
  fprintf(stderr,
    "RunAs -- Version 1.01 -- Copyright (C) 1994 -- S. Joel Katz\n");
  exit(1);
}

void main(int argc,char **argv)
{
 char *argv_ptrs[200],*envp_ptrs[200], *ptr;
 char msg[1024];
 int i,j,own_group, set_priority;
 uid_t target_uid;
 gid_t target_gid;
 struct passwd *pw;
 char *change_root, *change_dir, *input, *output, *error;
 change_root=NULL;
 change_dir=NULL;
 input=NULL;
 output=NULL;
 error=NULL;
 own_group=0;
 set_priority=0;
 while((i=getopt(argc,argv,"-gd:c:p:e:i:o:"))!=-1)
  switch(i)
  {
   case 'e': error=optarg;
             break;
   case 'i': input=optarg;
             break;
   case 'o': output=optarg;
             break;
   case 'd': change_dir=optarg;
             break;
   case 'c': change_root=optarg;
             break;
   case 'g': own_group=1;
             break;
   case 'p': set_priority=atoi(optarg);
             if((!set_priority)||(set_priority<-20)||(set_priority>20))
             {
              fprintf(stderr,"\nIllegal priority\n");
              usage();
             }
             break;
   case '?': fprintf(stderr,"\nUnknown option\n");
             usage();
             break;
   case ':': fprintf(stderr,"\nOption must take parameter\n");
             usage();
             break;
   case '-': break;
   default:  fprintf(stderr,"\nMalformed input (%d)\n",i);
             usage();
             break;
  }
 argc-=optind;
 argv+=optind;
 argc++;
 argv--;

 if(argc<3) usage();
/* Note: Do not change the order of these steps unless you know */
/* EXACTLY what you are doing!                                  */ 
 
 if(getuid()||geteuid())
 { 
  fprintf(stderr,"Real or effective ID not 0\n"); 
  exit(1); 
 }
 pw=getpwnam(argv[1]);
 if(pw==NULL)
  { 
   fprintf(stderr,"User \"%s\" doesn't exist.\n",argv[1]); 
   exit(1); 
  }
 target_uid=pw->pw_uid;
 target_gid=pw->pw_gid;
 if(setgid(target_gid)!=0)
  { 
   fprintf(stderr,"Couldn't switch group id (%s)\n",strerror(errno)); 
   exit(1); 
  }
 if(initgroups(argv[1],target_gid))
  { 
   fprintf(stderr,
     "Couldn't disable supplementary groups (%s).\n",strerror(errno));
   exit(1); 
  }
 if(error!=NULL)
 {
  close(2);
  if(strcmp("/",error))
   if(open(error,O_WRONLY|O_CREAT,384+48)!=2)
    fprintf(stderr,"Couldn't redirect stderr as directed\n");
 }
 if(output!=NULL)
 {
  close(1);
  if(strcmp("/",output))
   if(open(output,O_WRONLY|O_CREAT,384+48)!=1)
    fprintf(stderr,"Couldn't properly redirect standard output\n");
 }
 if(input!=NULL)
 {
  close(0);
  if(strcmp("/",input))
   if(open(input,O_RDONLY)!=0)
    fprintf(stderr,"Couldn't redirect input properly\n");
 }
 if(change_root!=NULL)  
 {
  if(chroot(change_root))
  {
   fprintf(stderr,"Could not change root directory to %s (%s)\n"
     ,change_root,strerror(errno));
   exit(1);
  }
 }
 if(own_group)
 {
  setsid();
  setpgrp();
 }
 if(set_priority)
 {
  if(setpriority((own_group ? PRIO_PGRP : PRIO_PROCESS),0,set_priority))
  {
   fprintf(stderr,"Couldn't set priority to %d (%s)\n"
      ,set_priority,strerror(errno));
  }
 }
 if(change_dir!=NULL)
 {
  if(chdir(change_dir))
  {
   fprintf(stderr,"Could not change directory to %s (%s)\n"
     ,change_dir,strerror(errno));
   exit(1);
  }
 }
 if(setuid(target_uid)!=0)
  { 
    fprintf(stderr,"Couldn't switch user id to %s(%d)\n",argv[1],target_uid);
    fprintf(stderr,"(%s)\n",strerror(errno)); 
    exit(1); 
  }
 argv_ptrs[0]=argv[2];
 
 for(i=3; i<argc; i++)
  argv_ptrs[i-2]=argv[i];
 argv_ptrs[i-2]=NULL;
 envp_ptrs[0]=NULL;
 execve(argv[2],argv_ptrs,envp_ptrs);
 if(errno==2)
 {
  fprintf(stderr,"Can't find %s\n",argv[2]);
  exit(1);
 }
 fprintf(stderr,
   "System error executing %s (%s)\n",argv[2],strerror(errno)); 
 exit(1);
}
