/*\
 *	DISTRIBUTION: HNMS v2.0
 *	FILE: hnmsd/rbip.c
 *
 *	HNMS RBIP module.
 *
 *	Jude George
 *	NAS Facility, NASA Ames Research Center
 *
 *	Copyright (c) 1994 Jude George
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\*/

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "stdhnms.h"

/*\
 *  Calculate the following variables for the appropriate objects:
 *  hnmsIpaddrBPS, hnmsIpaddrPPS, hnmsSubnetBPS, hnmsSubnetPPS,
 *  hnmsProcBPS, hnmsProcPPS.
\*/
int RBIP_calc_traffic()
{
    unsigned int	current_time, rci;
    static unsigned int	last_calc_time;

    current_time = get_int_time();
    rci = PARAM_get_int(oid_hnmsModuleRBIPCalcInterval);
    if (current_time - last_calc_time >=rci) {
	last_calc_time = current_time;
    }
    return 0;
}
