/*
 *
 *	defines.h
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include	"hnmsdefs.h"
#include	"constants.h"

#define		NUM_OBJCLASSES	(NUM_CLASSES+1)

#define		WANSTATUS	1
#define		CUSTOMSTATUS	2
#define		SITESTATUS	3
#define		OBJECTDUMP	4
#define		OBJECTDATA	5
#define		DEFAULT		6
#define		STATUSLOG	7
#define		NUM_VIEWCLASSES	8

#define		PING		9
#define		TELNET		10
#define		TRACEROUTE	11


#define		IPPARENT	0
#define		PHYSPARENT	1
#define		ADMINPARENT	2
#define		NUM_PARENT	3

#define		BLACK		0
#define		GREY		1
#define		WHITE		2
#define		RED		3
#define		GREEN		4
#define		YELLOW		5
#define		MAGENTA		6
#define		BLUE		7
#define		CYAN		8
#define		ORANGE		9

#define		N_COLORS	53


#define	SERVERFILE	"/serverlist"
#define	BACKGROUNDS	"/background/"

#define		CLOSE_PIXMAP	1
#define		HELP_PIXMAP	2
#define		MORE_PIXMAP	3
#define		CLEAR_PIXMAP	4
#define		OK_PIXMAP	5
#define		VIEWS_PIXMAP	6
#define		OBJECT_PIXMAP	7
#define		SERVBLK_PIXMAP	8
#define		SERVRED_PIXMAP	9
#define		SERVGRE_PIXMAP	10
#define		STATBLK_PIXMAP	11
#define		STATRED_PIXMAP	12

#define		NUM_ICONS	13

#define	X_STR(txt) XmStringLtoRCreate(txt, XmSTRING_DEFAULT_CHARSET)
#define	X_STRCMP(s1,s2) XmStringCompare(s1, s2)
#define	MAXIMUM(a,b)	(a>b ? a:b)
#define	MINIMUM(a,b)	(a<b ? a:b)
