/*
 *
 *	object.h
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include	<sys/types.h>

typedef		struct	objvarentry	{
		caddr_t			var;
		int			interval, recvonly;
		caddr_t			value;
		unsigned int		tsc;
		} OBJVARENTRY;

typedef		struct	object		{
		int			class,	hid;
		char			*uname, *name, *ext;
		unsigned int		ipaddr;
		caddr_t			varlist;
		struct object		*parent[NUM_PARENT];
		caddr_t			viewlist;
		caddr_t			def, state;
		} OBJECT;

int	AddObjectByName();
int	AddObjectByIPAddress();
int	AddObjectByHID();
void	AddObjectChildToView();
void	AddObjectParentToView();
void	AddViewToObject();
void	AnnounceObject();
void	AnnounceObjectsToView();
int	CompareClassAndName();
int	CompareHID();
int	CompareObjectHID();
int	CompareObjectIpaddress();
int	CompareObjectName();
int	CompareVariable();
void	DeleteObject();
void	DestroyObject();
void	DestroyObjects();
int	DestroyOBJVARENTRY();
void	DestroyUNKNOWNREL();
int	FindObjectByCN();
int	FindObjectByHID();
void	GetCurrentObject();
void	GetObjectPosition();
int	InitializeObjects();
int	LoadObject();
void	MakeObject();
void	MergeObjectVariables();
void	ObjectWalk();
void	Q_RequestObjectVariable();
void	RemoveObject();
int	RemoveViewFromObject();
void	RemoveViewFromObjects();
void	RequestObjectVariable();
void	ResolveUnknownRelations();
void	SendData();
void	SendRelation();
void	SetCurrentObject();
void	SetObjectParent();
void	ShowCurrentObjectDefault();
void	ShowCurrentObjectDump();
void	ShowCurrentObjectPing();
void	ShowCurrentObjectTelnet();
void	ShowCurrentObjectTraceroute();
void	SubscribeObjectRelations();
void	SubscribeObjectVariables();
void	UpdateRelation();
